
from _devbuild.gen.id_kind_asdl import Id, Kind
from _devbuild.gen.types_asdl import redir_arg_type_e, bool_arg_type_e


BOOL_ARG_TYPES = {
  Id.Op_DAmp: bool_arg_type_e.Undefined,
  Id.Op_DPipe: bool_arg_type_e.Undefined,
  Id.Op_Less: bool_arg_type_e.Str,
  Id.Op_Great: bool_arg_type_e.Str,
  Id.KW_Bang: bool_arg_type_e.Undefined,
  Id.BoolUnary_z: bool_arg_type_e.Str,
  Id.BoolUnary_n: bool_arg_type_e.Str,
  Id.BoolUnary_o: bool_arg_type_e.Other,
  Id.BoolUnary_t: bool_arg_type_e.Other,
  Id.BoolUnary_v: bool_arg_type_e.Other,
  Id.BoolUnary_R: bool_arg_type_e.Other,
  Id.BoolUnary_a: bool_arg_type_e.Path,
  Id.BoolUnary_b: bool_arg_type_e.Path,
  Id.BoolUnary_c: bool_arg_type_e.Path,
  Id.BoolUnary_d: bool_arg_type_e.Path,
  Id.BoolUnary_e: bool_arg_type_e.Path,
  Id.BoolUnary_f: bool_arg_type_e.Path,
  Id.BoolUnary_g: bool_arg_type_e.Path,
  Id.BoolUnary_h: bool_arg_type_e.Path,
  Id.BoolUnary_k: bool_arg_type_e.Path,
  Id.BoolUnary_L: bool_arg_type_e.Path,
  Id.BoolUnary_p: bool_arg_type_e.Path,
  Id.BoolUnary_r: bool_arg_type_e.Path,
  Id.BoolUnary_s: bool_arg_type_e.Path,
  Id.BoolUnary_S: bool_arg_type_e.Path,
  Id.BoolUnary_u: bool_arg_type_e.Path,
  Id.BoolUnary_w: bool_arg_type_e.Path,
  Id.BoolUnary_x: bool_arg_type_e.Path,
  Id.BoolUnary_O: bool_arg_type_e.Path,
  Id.BoolUnary_G: bool_arg_type_e.Path,
  Id.BoolUnary_N: bool_arg_type_e.Path,
  Id.BoolUnary_true: bool_arg_type_e.Str,
  Id.BoolUnary_false: bool_arg_type_e.Str,
  Id.BoolBinary_GlobEqual: bool_arg_type_e.Str,
  Id.BoolBinary_GlobDEqual: bool_arg_type_e.Str,
  Id.BoolBinary_GlobNEqual: bool_arg_type_e.Str,
  Id.BoolBinary_EqualTilde: bool_arg_type_e.Str,
  Id.BoolBinary_ef: bool_arg_type_e.Path,
  Id.BoolBinary_nt: bool_arg_type_e.Path,
  Id.BoolBinary_ot: bool_arg_type_e.Path,
  Id.BoolBinary_eq: bool_arg_type_e.Int,
  Id.BoolBinary_ne: bool_arg_type_e.Int,
  Id.BoolBinary_gt: bool_arg_type_e.Int,
  Id.BoolBinary_ge: bool_arg_type_e.Int,
  Id.BoolBinary_lt: bool_arg_type_e.Int,
  Id.BoolBinary_le: bool_arg_type_e.Int,
  Id.BoolBinary_Equal: bool_arg_type_e.Str,
  Id.BoolBinary_DEqual: bool_arg_type_e.Str,
  Id.BoolBinary_NEqual: bool_arg_type_e.Str,
}

TEST_UNARY_LOOKUP = {
  '-G': Id.BoolUnary_G,
  '-L': Id.BoolUnary_L,
  '-N': Id.BoolUnary_N,
  '-O': Id.BoolUnary_O,
  '-R': Id.BoolUnary_R,
  '-S': Id.BoolUnary_S,
  '-a': Id.BoolUnary_a,
  '-b': Id.BoolUnary_b,
  '-c': Id.BoolUnary_c,
  '-d': Id.BoolUnary_d,
  '-e': Id.BoolUnary_e,
  '-f': Id.BoolUnary_f,
  '-g': Id.BoolUnary_g,
  '-h': Id.BoolUnary_h,
  '-k': Id.BoolUnary_k,
  '-n': Id.BoolUnary_n,
  '-o': Id.BoolUnary_o,
  '-p': Id.BoolUnary_p,
  '-r': Id.BoolUnary_r,
  '-s': Id.BoolUnary_s,
  '-t': Id.BoolUnary_t,
  '-u': Id.BoolUnary_u,
  '-v': Id.BoolUnary_v,
  '-w': Id.BoolUnary_w,
  '-x': Id.BoolUnary_x,
  '-z': Id.BoolUnary_z,
}

TEST_BINARY_LOOKUP = {
  '!=': Id.BoolBinary_NEqual,
  '-ef': Id.BoolBinary_ef,
  '-eq': Id.BoolBinary_eq,
  '-ge': Id.BoolBinary_ge,
  '-gt': Id.BoolBinary_gt,
  '-le': Id.BoolBinary_le,
  '-lt': Id.BoolBinary_lt,
  '-ne': Id.BoolBinary_ne,
  '-nt': Id.BoolBinary_nt,
  '-ot': Id.BoolBinary_ot,
  '<': Id.Op_Less,
  '=': Id.BoolBinary_Equal,
  '==': Id.BoolBinary_DEqual,
  '>': Id.Op_Great,
}

TEST_OTHER_LOOKUP = {
  '!': Id.KW_Bang,
  '(': Id.Op_LParen,
  ')': Id.Op_RParen,
  ']': Id.Arith_RBracket,
}

ID_TO_KIND = {
  Id.Word_Compound: Kind.Word,
  Id.Arith_Semi: Kind.Arith,
  Id.Arith_Comma: Kind.Arith,
  Id.Arith_Plus: Kind.Arith,
  Id.Arith_Minus: Kind.Arith,
  Id.Arith_Star: Kind.Arith,
  Id.Arith_Slash: Kind.Arith,
  Id.Arith_Percent: Kind.Arith,
  Id.Arith_DPlus: Kind.Arith,
  Id.Arith_DMinus: Kind.Arith,
  Id.Arith_DStar: Kind.Arith,
  Id.Arith_LParen: Kind.Arith,
  Id.Arith_RParen: Kind.Arith,
  Id.Arith_LBracket: Kind.Arith,
  Id.Arith_RBracket: Kind.Arith,
  Id.Arith_RBrace: Kind.Arith,
  Id.Arith_QMark: Kind.Arith,
  Id.Arith_Colon: Kind.Arith,
  Id.Arith_LessEqual: Kind.Arith,
  Id.Arith_Less: Kind.Arith,
  Id.Arith_GreatEqual: Kind.Arith,
  Id.Arith_Great: Kind.Arith,
  Id.Arith_DEqual: Kind.Arith,
  Id.Arith_NEqual: Kind.Arith,
  Id.Arith_DAmp: Kind.Arith,
  Id.Arith_DPipe: Kind.Arith,
  Id.Arith_Bang: Kind.Arith,
  Id.Arith_DGreat: Kind.Arith,
  Id.Arith_DLess: Kind.Arith,
  Id.Arith_Amp: Kind.Arith,
  Id.Arith_Pipe: Kind.Arith,
  Id.Arith_Caret: Kind.Arith,
  Id.Arith_Tilde: Kind.Arith,
  Id.Arith_Equal: Kind.Arith,
  Id.Arith_PlusEqual: Kind.Arith,
  Id.Arith_MinusEqual: Kind.Arith,
  Id.Arith_StarEqual: Kind.Arith,
  Id.Arith_SlashEqual: Kind.Arith,
  Id.Arith_PercentEqual: Kind.Arith,
  Id.Arith_DGreatEqual: Kind.Arith,
  Id.Arith_DLessEqual: Kind.Arith,
  Id.Arith_AmpEqual: Kind.Arith,
  Id.Arith_CaretEqual: Kind.Arith,
  Id.Arith_PipeEqual: Kind.Arith,
  Id.Eof_Real: Kind.Eof,
  Id.Eof_RParen: Kind.Eof,
  Id.Eof_Backtick: Kind.Eof,
  Id.Undefined_Tok: Kind.Undefined,
  Id.Unknown_Tok: Kind.Unknown,
  Id.Unknown_Backslash: Kind.Unknown,
  Id.Unknown_DEqual: Kind.Unknown,
  Id.Unknown_DAmp: Kind.Unknown,
  Id.Unknown_DPipe: Kind.Unknown,
  Id.Unknown_DDot: Kind.Unknown,
  Id.Eol_Tok: Kind.Eol,
  Id.Ignored_LineCont: Kind.Ignored,
  Id.Ignored_Space: Kind.Ignored,
  Id.Ignored_Comment: Kind.Ignored,
  Id.Ignored_Newline: Kind.Ignored,
  Id.WS_Space: Kind.WS,
  Id.Lit_Chars: Kind.Lit,
  Id.Lit_CharsWithoutPrefix: Kind.Lit,
  Id.Lit_VarLike: Kind.Lit,
  Id.Lit_ArrayLhsOpen: Kind.Lit,
  Id.Lit_ArrayLhsClose: Kind.Lit,
  Id.Lit_Splice: Kind.Lit,
  Id.Lit_AtLBracket: Kind.Lit,
  Id.Lit_AtLBraceDot: Kind.Lit,
  Id.Lit_Other: Kind.Lit,
  Id.Lit_EscapedChar: Kind.Lit,
  Id.Lit_BackslashDoubleQuote: Kind.Lit,
  Id.Lit_LBracket: Kind.Lit,
  Id.Lit_RBracket: Kind.Lit,
  Id.Lit_Star: Kind.Lit,
  Id.Lit_QMark: Kind.Lit,
  Id.Lit_LBrace: Kind.Lit,
  Id.Lit_RBrace: Kind.Lit,
  Id.Lit_Comma: Kind.Lit,
  Id.Lit_Equals: Kind.Lit,
  Id.Lit_Dollar: Kind.Lit,
  Id.Lit_DRightBracket: Kind.Lit,
  Id.Lit_Tilde: Kind.Lit,
  Id.Lit_Pound: Kind.Lit,
  Id.Lit_TPound: Kind.Lit,
  Id.Lit_TDot: Kind.Lit,
  Id.Lit_Slash: Kind.Lit,
  Id.Lit_Percent: Kind.Lit,
  Id.Lit_Colon: Kind.Lit,
  Id.Lit_Digits: Kind.Lit,
  Id.Lit_At: Kind.Lit,
  Id.Lit_ArithVarLike: Kind.Lit,
  Id.Lit_BadBackslash: Kind.Lit,
  Id.Lit_CompDummy: Kind.Lit,
  Id.Lit_Number: Kind.Lit,
  Id.Lit_RedirVarName: Kind.Lit,
  Id.Backtick_Right: Kind.Backtick,
  Id.Backtick_Quoted: Kind.Backtick,
  Id.Backtick_DoubleQuote: Kind.Backtick,
  Id.Backtick_Other: Kind.Backtick,
  Id.History_Op: Kind.History,
  Id.History_Num: Kind.History,
  Id.History_Search: Kind.History,
  Id.History_Other: Kind.History,
  Id.Op_Newline: Kind.Op,
  Id.Op_Amp: Kind.Op,
  Id.Op_Pipe: Kind.Op,
  Id.Op_PipeAmp: Kind.Op,
  Id.Op_DAmp: Kind.Op,
  Id.Op_DPipe: Kind.Op,
  Id.Op_Semi: Kind.Op,
  Id.Op_DSemi: Kind.Op,
  Id.Op_SemiAmp: Kind.Op,
  Id.Op_DSemiAmp: Kind.Op,
  Id.Op_LParen: Kind.Op,
  Id.Op_RParen: Kind.Op,
  Id.Op_DLeftParen: Kind.Op,
  Id.Op_DRightParen: Kind.Op,
  Id.Op_Less: Kind.Op,
  Id.Op_Great: Kind.Op,
  Id.Op_Bang: Kind.Op,
  Id.Op_LBracket: Kind.Op,
  Id.Op_RBracket: Kind.Op,
  Id.Op_LBrace: Kind.Op,
  Id.Op_RBrace: Kind.Op,
  Id.Expr_Reserved: Kind.Expr,
  Id.Expr_Symbol: Kind.Expr,
  Id.Expr_Name: Kind.Expr,
  Id.Expr_DecInt: Kind.Expr,
  Id.Expr_BinInt: Kind.Expr,
  Id.Expr_OctInt: Kind.Expr,
  Id.Expr_HexInt: Kind.Expr,
  Id.Expr_Float: Kind.Expr,
  Id.Expr_Bang: Kind.Expr,
  Id.Expr_Dot: Kind.Expr,
  Id.Expr_DDotLessThan: Kind.Expr,
  Id.Expr_DDotEqual: Kind.Expr,
  Id.Expr_Colon: Kind.Expr,
  Id.Expr_RArrow: Kind.Expr,
  Id.Expr_RDArrow: Kind.Expr,
  Id.Expr_DSlash: Kind.Expr,
  Id.Expr_TEqual: Kind.Expr,
  Id.Expr_NotDEqual: Kind.Expr,
  Id.Expr_TildeDEqual: Kind.Expr,
  Id.Expr_At: Kind.Expr,
  Id.Expr_DoubleAt: Kind.Expr,
  Id.Expr_Ellipsis: Kind.Expr,
  Id.Expr_Dollar: Kind.Expr,
  Id.Expr_NotTilde: Kind.Expr,
  Id.Expr_DTilde: Kind.Expr,
  Id.Expr_NotDTilde: Kind.Expr,
  Id.Expr_DStarEqual: Kind.Expr,
  Id.Expr_DSlashEqual: Kind.Expr,
  Id.Expr_CastedDummy: Kind.Expr,
  Id.Expr_Null: Kind.Expr,
  Id.Expr_True: Kind.Expr,
  Id.Expr_False: Kind.Expr,
  Id.Expr_And: Kind.Expr,
  Id.Expr_Or: Kind.Expr,
  Id.Expr_Not: Kind.Expr,
  Id.Expr_For: Kind.Expr,
  Id.Expr_Is: Kind.Expr,
  Id.Expr_In: Kind.Expr,
  Id.Expr_If: Kind.Expr,
  Id.Expr_Else: Kind.Expr,
  Id.Expr_Capture: Kind.Expr,
  Id.Expr_As: Kind.Expr,
  Id.Expr_Func: Kind.Expr,
  Id.Expr_Proc: Kind.Expr,
  Id.Char_OneChar: Kind.Char,
  Id.Char_Stop: Kind.Char,
  Id.Char_Hex: Kind.Char,
  Id.Char_YHex: Kind.Char,
  Id.Char_Octal3: Kind.Char,
  Id.Char_Octal4: Kind.Char,
  Id.Char_Unicode4: Kind.Char,
  Id.Char_SurrogatePair: Kind.Char,
  Id.Char_Unicode8: Kind.Char,
  Id.Char_UBraced: Kind.Char,
  Id.Char_Pound: Kind.Char,
  Id.Char_AsciiControl: Kind.Char,
  Id.BashRegex_LParen: Kind.BashRegex,
  Id.BashRegex_AllowedInParens: Kind.BashRegex,
  Id.Eggex_Start: Kind.Eggex,
  Id.Eggex_End: Kind.Eggex,
  Id.Eggex_Dot: Kind.Eggex,
  Id.Redir_Less: Kind.Redir,
  Id.Redir_Great: Kind.Redir,
  Id.Redir_DLess: Kind.Redir,
  Id.Redir_TLess: Kind.Redir,
  Id.Redir_DGreat: Kind.Redir,
  Id.Redir_GreatAnd: Kind.Redir,
  Id.Redir_LessAnd: Kind.Redir,
  Id.Redir_DLessDash: Kind.Redir,
  Id.Redir_LessGreat: Kind.Redir,
  Id.Redir_Clobber: Kind.Redir,
  Id.Redir_AndGreat: Kind.Redir,
  Id.Redir_AndDGreat: Kind.Redir,
  Id.Left_DoubleQuote: Kind.Left,
  Id.Left_JDoubleQuote: Kind.Left,
  Id.Left_SingleQuote: Kind.Left,
  Id.Left_DollarSingleQuote: Kind.Left,
  Id.Left_RSingleQuote: Kind.Left,
  Id.Left_USingleQuote: Kind.Left,
  Id.Left_BSingleQuote: Kind.Left,
  Id.Left_TDoubleQuote: Kind.Left,
  Id.Left_DollarTDoubleQuote: Kind.Left,
  Id.Left_TSingleQuote: Kind.Left,
  Id.Left_RTSingleQuote: Kind.Left,
  Id.Left_UTSingleQuote: Kind.Left,
  Id.Left_BTSingleQuote: Kind.Left,
  Id.Left_Backtick: Kind.Left,
  Id.Left_DollarParen: Kind.Left,
  Id.Left_DollarBrace: Kind.Left,
  Id.Left_DollarBraceZsh: Kind.Left,
  Id.Left_DollarDParen: Kind.Left,
  Id.Left_DollarBracket: Kind.Left,
  Id.Left_AtBracket: Kind.Left,
  Id.Left_DollarDoubleQuote: Kind.Left,
  Id.Left_ProcSubIn: Kind.Left,
  Id.Left_ProcSubOut: Kind.Left,
  Id.Left_AtParen: Kind.Left,
  Id.Left_CaretParen: Kind.Left,
  Id.Left_CaretBracket: Kind.Left,
  Id.Left_CaretBrace: Kind.Left,
  Id.Left_CaretDoubleQuote: Kind.Left,
  Id.Left_ColonPipe: Kind.Left,
  Id.Left_PercentParen: Kind.Left,
  Id.Right_DoubleQuote: Kind.Right,
  Id.Right_SingleQuote: Kind.Right,
  Id.Right_Backtick: Kind.Right,
  Id.Right_DollarBrace: Kind.Right,
  Id.Right_DollarDParen: Kind.Right,
  Id.Right_DollarDoubleQuote: Kind.Right,
  Id.Right_DollarSingleQuote: Kind.Right,
  Id.Right_Subshell: Kind.Right,
  Id.Right_ShFunction: Kind.Right,
  Id.Right_CasePat: Kind.Right,
  Id.Right_Initializer: Kind.Right,
  Id.Right_ExtGlob: Kind.Right,
  Id.Right_BashRegexGroup: Kind.Right,
  Id.Right_BlockLiteral: Kind.Right,
  Id.ExtGlob_Comma: Kind.ExtGlob,
  Id.ExtGlob_At: Kind.ExtGlob,
  Id.ExtGlob_Star: Kind.ExtGlob,
  Id.ExtGlob_Plus: Kind.ExtGlob,
  Id.ExtGlob_QMark: Kind.ExtGlob,
  Id.ExtGlob_Bang: Kind.ExtGlob,
  Id.VSub_DollarName: Kind.VSub,
  Id.VSub_Name: Kind.VSub,
  Id.VSub_Number: Kind.VSub,
  Id.VSub_Bang: Kind.VSub,
  Id.VSub_At: Kind.VSub,
  Id.VSub_Pound: Kind.VSub,
  Id.VSub_Dollar: Kind.VSub,
  Id.VSub_Star: Kind.VSub,
  Id.VSub_Hyphen: Kind.VSub,
  Id.VSub_QMark: Kind.VSub,
  Id.VSub_Dot: Kind.VSub,
  Id.VTest_ColonHyphen: Kind.VTest,
  Id.VTest_Hyphen: Kind.VTest,
  Id.VTest_ColonEquals: Kind.VTest,
  Id.VTest_Equals: Kind.VTest,
  Id.VTest_ColonQMark: Kind.VTest,
  Id.VTest_QMark: Kind.VTest,
  Id.VTest_ColonPlus: Kind.VTest,
  Id.VTest_Plus: Kind.VTest,
  Id.VOp0_Q: Kind.VOp0,
  Id.VOp0_E: Kind.VOp0,
  Id.VOp0_P: Kind.VOp0,
  Id.VOp0_A: Kind.VOp0,
  Id.VOp0_a: Kind.VOp0,
  Id.VOp1_Percent: Kind.VOp1,
  Id.VOp1_DPercent: Kind.VOp1,
  Id.VOp1_Pound: Kind.VOp1,
  Id.VOp1_DPound: Kind.VOp1,
  Id.VOp1_Caret: Kind.VOp1,
  Id.VOp1_DCaret: Kind.VOp1,
  Id.VOp1_Comma: Kind.VOp1,
  Id.VOp1_DComma: Kind.VOp1,
  Id.VOpYsh_Pipe: Kind.VOpYsh,
  Id.VOpYsh_Space: Kind.VOpYsh,
  Id.VOp2_Slash: Kind.VOp2,
  Id.VOp2_Colon: Kind.VOp2,
  Id.VOp2_LBracket: Kind.VOp2,
  Id.VOp2_RBracket: Kind.VOp2,
  Id.VOp3_At: Kind.VOp3,
  Id.VOp3_Star: Kind.VOp3,
  Id.Node_PostDPlus: Kind.Node,
  Id.Node_PostDMinus: Kind.Node,
  Id.Node_UnaryPlus: Kind.Node,
  Id.Node_UnaryMinus: Kind.Node,
  Id.Node_NotIn: Kind.Node,
  Id.Node_IsNot: Kind.Node,
  Id.KW_DLeftBracket: Kind.KW,
  Id.KW_Bang: Kind.KW,
  Id.KW_For: Kind.KW,
  Id.KW_While: Kind.KW,
  Id.KW_Until: Kind.KW,
  Id.KW_Do: Kind.KW,
  Id.KW_Done: Kind.KW,
  Id.KW_In: Kind.KW,
  Id.KW_Case: Kind.KW,
  Id.KW_Esac: Kind.KW,
  Id.KW_If: Kind.KW,
  Id.KW_Fi: Kind.KW,
  Id.KW_Then: Kind.KW,
  Id.KW_Else: Kind.KW,
  Id.KW_Elif: Kind.KW,
  Id.KW_Function: Kind.KW,
  Id.KW_Time: Kind.KW,
  Id.KW_Const: Kind.KW,
  Id.KW_Var: Kind.KW,
  Id.KW_SetVar: Kind.KW,
  Id.KW_SetGlobal: Kind.KW,
  Id.KW_Call: Kind.KW,
  Id.KW_Proc: Kind.KW,
  Id.KW_Typed: Kind.KW,
  Id.KW_Func: Kind.KW,
  Id.ControlFlow_Break: Kind.ControlFlow,
  Id.ControlFlow_Continue: Kind.ControlFlow,
  Id.ControlFlow_Return: Kind.ControlFlow,
  Id.ControlFlow_Exit: Kind.ControlFlow,
  Id.LookAhead_FuncParens: Kind.LookAhead,
  Id.Glob_LBracket: Kind.Glob,
  Id.Glob_RBracket: Kind.Glob,
  Id.Glob_Star: Kind.Glob,
  Id.Glob_QMark: Kind.Glob,
  Id.Glob_Bang: Kind.Glob,
  Id.Glob_Caret: Kind.Glob,
  Id.Glob_EscapedChar: Kind.Glob,
  Id.Glob_BadBackslash: Kind.Glob,
  Id.Glob_CleanLiterals: Kind.Glob,
  Id.Glob_OtherLiteral: Kind.Glob,
  Id.Format_EscapedPercent: Kind.Format,
  Id.Format_Percent: Kind.Format,
  Id.Format_Flag: Kind.Format,
  Id.Format_Num: Kind.Format,
  Id.Format_Dot: Kind.Format,
  Id.Format_Type: Kind.Format,
  Id.Format_Star: Kind.Format,
  Id.Format_Time: Kind.Format,
  Id.Format_Zero: Kind.Format,
  Id.PS_Subst: Kind.PS,
  Id.PS_Octal3: Kind.PS,
  Id.PS_LBrace: Kind.PS,
  Id.PS_RBrace: Kind.PS,
  Id.PS_Literals: Kind.PS,
  Id.PS_BadBackslash: Kind.PS,
  Id.Range_Int: Kind.Range,
  Id.Range_Char: Kind.Range,
  Id.Range_Dots: Kind.Range,
  Id.Range_Other: Kind.Range,
  Id.J8_LBracket: Kind.J8,
  Id.J8_RBracket: Kind.J8,
  Id.J8_LBrace: Kind.J8,
  Id.J8_RBrace: Kind.J8,
  Id.J8_Comma: Kind.J8,
  Id.J8_Colon: Kind.J8,
  Id.J8_Null: Kind.J8,
  Id.J8_Bool: Kind.J8,
  Id.J8_Int: Kind.J8,
  Id.J8_Float: Kind.J8,
  Id.J8_String: Kind.J8,
  Id.J8_Identifier: Kind.J8,
  Id.J8_Newline: Kind.J8,
  Id.J8_Tab: Kind.J8,
  Id.J8_LParen: Kind.J8,
  Id.J8_RParen: Kind.J8,
  Id.J8_Operator: Kind.J8,
  Id.ShNumber_Dec: Kind.ShNumber,
  Id.ShNumber_Hex: Kind.ShNumber,
  Id.ShNumber_Oct: Kind.ShNumber,
  Id.ShNumber_BaseN: Kind.ShNumber,
  Id.BoolUnary_z: Kind.BoolUnary,
  Id.BoolUnary_n: Kind.BoolUnary,
  Id.BoolUnary_o: Kind.BoolUnary,
  Id.BoolUnary_t: Kind.BoolUnary,
  Id.BoolUnary_v: Kind.BoolUnary,
  Id.BoolUnary_R: Kind.BoolUnary,
  Id.BoolUnary_a: Kind.BoolUnary,
  Id.BoolUnary_b: Kind.BoolUnary,
  Id.BoolUnary_c: Kind.BoolUnary,
  Id.BoolUnary_d: Kind.BoolUnary,
  Id.BoolUnary_e: Kind.BoolUnary,
  Id.BoolUnary_f: Kind.BoolUnary,
  Id.BoolUnary_g: Kind.BoolUnary,
  Id.BoolUnary_h: Kind.BoolUnary,
  Id.BoolUnary_k: Kind.BoolUnary,
  Id.BoolUnary_L: Kind.BoolUnary,
  Id.BoolUnary_p: Kind.BoolUnary,
  Id.BoolUnary_r: Kind.BoolUnary,
  Id.BoolUnary_s: Kind.BoolUnary,
  Id.BoolUnary_S: Kind.BoolUnary,
  Id.BoolUnary_u: Kind.BoolUnary,
  Id.BoolUnary_w: Kind.BoolUnary,
  Id.BoolUnary_x: Kind.BoolUnary,
  Id.BoolUnary_O: Kind.BoolUnary,
  Id.BoolUnary_G: Kind.BoolUnary,
  Id.BoolUnary_N: Kind.BoolUnary,
  Id.BoolUnary_true: Kind.BoolBinary,
  Id.BoolUnary_false: Kind.BoolBinary,
  Id.BoolBinary_GlobEqual: Kind.BoolBinary,
  Id.BoolBinary_GlobDEqual: Kind.BoolBinary,
  Id.BoolBinary_GlobNEqual: Kind.BoolBinary,
  Id.BoolBinary_EqualTilde: Kind.BoolBinary,
  Id.BoolBinary_ef: Kind.BoolBinary,
  Id.BoolBinary_nt: Kind.BoolBinary,
  Id.BoolBinary_ot: Kind.BoolBinary,
  Id.BoolBinary_eq: Kind.BoolBinary,
  Id.BoolBinary_ne: Kind.BoolBinary,
  Id.BoolBinary_gt: Kind.BoolBinary,
  Id.BoolBinary_ge: Kind.BoolBinary,
  Id.BoolBinary_lt: Kind.BoolBinary,
  Id.BoolBinary_le: Kind.BoolBinary,
  Id.BoolBinary_Equal: Kind.BoolBinary,
  Id.BoolBinary_DEqual: Kind.BoolBinary,
  Id.BoolBinary_NEqual: Kind.BoolBinary,
}
