// _gen/frontend/syntax.asdl.cc is generated by asdl_main.py

#include "_gen/frontend/syntax.asdl.h"
#include <assert.h>
#include "prebuilt/frontend/syntax_abbrev.mycpp.h"
#include "prebuilt/asdl/runtime.mycpp.h"  // generated code uses wrappers here
#include "_gen/core/value.asdl.h"  // "use" in ASDL 

// Generated code uses these types
using hnode_asdl::hnode;
using hnode_asdl::Field;
using hnode_asdl::color_e;

using id_kind_asdl::Id_str;

namespace syntax_asdl {


hnode_t* BoolParamBox::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("BoolParamBox"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = ToPretty(this->b);
  L->append(Alloc<Field>(StrFromC("b"), x0));

  return out_node;
}


hnode_t* IntParamBox::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("IntParamBox"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = ToPretty(this->i);
  L->append(Alloc<Field>(StrFromC("i"), x0));

  return out_node;
}

BigStr* parse_result_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case parse_result_e::EmptyLine:
    v = "EmptyLine"; break;
  case parse_result_e::Eof:
    v = "Eof"; break;
  case parse_result_e::Node:
    v = "Node"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "parse_result.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

parse_result__EmptyLine* parse_result::EmptyLine =
&gparse_result__EmptyLine.obj;

GcGlobal<parse_result__EmptyLine> gparse_result__EmptyLine = 
  { ObjHeader::Global(parse_result_e::EmptyLine) };

parse_result__Eof* parse_result::Eof = &gparse_result__Eof.obj;

GcGlobal<parse_result__Eof> gparse_result__Eof = 
  { ObjHeader::Global(parse_result_e::Eof) };

hnode_t* parse_result__EmptyLine::PrettyTree(bool do_abbrev, Dict<int, bool>*
                                             seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(parse_result_str(this->tag()));
  return out_node;
}


hnode_t* parse_result__Eof::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(parse_result_str(this->tag()));
  return out_node;
}


hnode_t* parse_result__Node::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(parse_result_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->cmd->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("cmd"), x0));

  return out_node;
}


hnode_t* parse_result_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case parse_result_e::EmptyLine: {
    parse_result__EmptyLine* obj = static_cast<parse_result__EmptyLine*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case parse_result_e::Eof: {
    parse_result__Eof* obj = static_cast<parse_result__Eof*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case parse_result_e::Node: {
    parse_result__Node* obj = static_cast<parse_result__Node*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}
BigStr* source_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case source_e::Interactive:
    v = "Interactive"; break;
  case source_e::Headless:
    v = "Headless"; break;
  case source_e::Unused:
    v = "Unused"; break;
  case source_e::CFlag:
    v = "CFlag"; break;
  case source_e::Stdin:
    v = "Stdin"; break;
  case source_e::MainFile:
    v = "MainFile"; break;
  case source_e::OtherFile:
    v = "OtherFile"; break;
  case source_e::Dynamic:
    v = "Dynamic"; break;
  case source_e::VarRef:
    v = "VarRef"; break;
  case source_e::Variable:
    v = "Variable"; break;
  case source_e::Alias:
    v = "Alias"; break;
  case source_e::Reparsed:
    v = "Reparsed"; break;
  case source_e::Synthetic:
    v = "Synthetic"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "source.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

source__Interactive* source::Interactive = &gsource__Interactive.obj;

GcGlobal<source__Interactive> gsource__Interactive = 
  { ObjHeader::Global(source_e::Interactive) };

source__Headless* source::Headless = &gsource__Headless.obj;

GcGlobal<source__Headless> gsource__Headless = 
  { ObjHeader::Global(source_e::Headless) };

source__CFlag* source::CFlag = &gsource__CFlag.obj;

GcGlobal<source__CFlag> gsource__CFlag = 
  { ObjHeader::Global(source_e::CFlag) };

hnode_t* source__Interactive::PrettyTree(bool do_abbrev, Dict<int, bool>* seen)
                                         {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(source_str(this->tag()));
  return out_node;
}


hnode_t* source__Headless::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(source_str(this->tag()));
  return out_node;
}


hnode_t* source__Unused::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(source_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = ToPretty(this->comment);
  L->append(Alloc<Field>(StrFromC("comment"), x0));

  return out_node;
}


hnode_t* source__CFlag::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(source_str(this->tag()));
  return out_node;
}


hnode_t* source__Stdin::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(source_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = ToPretty(this->comment);
  L->append(Alloc<Field>(StrFromC("comment"), x0));

  return out_node;
}


hnode_t* source__MainFile::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(source_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = ToPretty(this->path);
  L->append(Alloc<Field>(StrFromC("path"), x0));

  return out_node;
}


hnode_t* source__OtherFile::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(source_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = ToPretty(this->path);
  L->append(Alloc<Field>(StrFromC("path"), x0));

  hnode_t* x1 = this->location->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("location"), x1));

  return out_node;
}


hnode_t* source__Dynamic::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(source_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = ToPretty(this->what);
  L->append(Alloc<Field>(StrFromC("what"), x0));

  hnode_t* x1 = this->location->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("location"), x1));

  return out_node;
}


hnode_t* source__VarRef::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(source_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->orig_tok->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("orig_tok"), x0));

  return out_node;
}


hnode_t* source__Variable::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(source_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = ToPretty(this->var_name);
  L->append(Alloc<Field>(StrFromC("var_name"), x0));

  hnode_t* x1 = this->location->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("location"), x1));

  return out_node;
}


hnode_t* source__Alias::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(source_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = ToPretty(this->argv0);
  L->append(Alloc<Field>(StrFromC("argv0"), x0));

  hnode_t* x1 = this->argv0_loc->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("argv0_loc"), x1));

  return out_node;
}


hnode_t* source__Reparsed::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(source_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = ToPretty(this->what);
  L->append(Alloc<Field>(StrFromC("what"), x0));

  hnode_t* x1 = this->left_token->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left_token"), x1));

  hnode_t* x2 = this->right_token->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("right_token"), x2));

  return out_node;
}


hnode_t* source__Synthetic::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(source_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = ToPretty(this->s);
  L->append(Alloc<Field>(StrFromC("s"), x0));

  return out_node;
}


hnode_t* source_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case source_e::Interactive: {
    source__Interactive* obj = static_cast<source__Interactive*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case source_e::Headless: {
    source__Headless* obj = static_cast<source__Headless*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case source_e::Unused: {
    source__Unused* obj = static_cast<source__Unused*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case source_e::CFlag: {
    source__CFlag* obj = static_cast<source__CFlag*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case source_e::Stdin: {
    source__Stdin* obj = static_cast<source__Stdin*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case source_e::MainFile: {
    source__MainFile* obj = static_cast<source__MainFile*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case source_e::OtherFile: {
    source__OtherFile* obj = static_cast<source__OtherFile*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case source_e::Dynamic: {
    source__Dynamic* obj = static_cast<source__Dynamic*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case source_e::VarRef: {
    source__VarRef* obj = static_cast<source__VarRef*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case source_e::Variable: {
    source__Variable* obj = static_cast<source__Variable*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case source_e::Alias: {
    source__Alias* obj = static_cast<source__Alias*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case source_e::Reparsed: {
    source__Reparsed* obj = static_cast<source__Reparsed*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case source_e::Synthetic: {
    source__Synthetic* obj = static_cast<source__Synthetic*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}

hnode_t* SourceLine::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("SourceLine"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = ToPretty(this->line_num);
  L->append(Alloc<Field>(StrFromC("line_num"), x0));

  hnode_t* x1 = ToPretty(this->content);
  L->append(Alloc<Field>(StrFromC("content"), x1));

  hnode_t* x2 = this->src->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("src"), x2));

  return out_node;
}


hnode_t* Token::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  if (do_abbrev) {
    auto* p = syntax_abbrev::_Token(this);
    if (p) {
      return p;
    }
  }
  hnode::Record* out_node = runtime::NewRecord(StrFromC("Token"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = Alloc<hnode::Leaf>(Id_str(this->id, false), color_e::UserType);
  L->append(Alloc<Field>(StrFromC("id"), x0));

  hnode_t* x1 = ToPretty(this->length);
  L->append(Alloc<Field>(StrFromC("length"), x1));

  hnode_t* x2 = ToPretty(this->col);
  L->append(Alloc<Field>(StrFromC("col"), x2));

  if (this->line) {  // Optional
    hnode_t* x3 = this->line->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("line"), x3));
  }

  if (this->tval) {  // Optional
    hnode_t* x4 = ToPretty(this->tval);
    L->append(Alloc<Field>(StrFromC("tval"), x4));
  }

  return out_node;
}


hnode_t* CompoundWord::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  if (do_abbrev) {
    auto* p = syntax_abbrev::_CompoundWord(this);
    if (p) {
      return p;
    }
  }
  hnode::Record* out_node = runtime::NewRecord(StrFromC("CompoundWord"));
  List<Field*>* L = out_node->fields;

  if (this->parts != nullptr) {  // List
    hnode::Array* x0 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<word_part_t*> it(this->parts); !it.Done(); it.Next()) {
      word_part_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x0->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("parts"), x0));
  }

  return out_node;
}

BigStr* loc_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case loc_e::Missing:
    v = "Missing"; break;
  case loc_e::Token:
    v = "Token"; break;
  case loc_e::ArgWord:
    v = "ArgWord"; break;
  case loc_e::WordPart:
    v = "WordPart"; break;
  case loc_e::Word:
    v = "Word"; break;
  case loc_e::Arith:
    v = "Arith"; break;
  case loc_e::Command:
    v = "Command"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "loc.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

loc__Missing* loc::Missing = &gloc__Missing.obj;

GcGlobal<loc__Missing> gloc__Missing = 
  { ObjHeader::Global(loc_e::Missing) };

hnode_t* loc__Missing::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(loc_str(this->tag()));
  return out_node;
}


hnode_t* loc__WordPart::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(loc_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->p->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("p"), x0));

  return out_node;
}


hnode_t* loc__Word::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(loc_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->w->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("w"), x0));

  return out_node;
}


hnode_t* loc__Arith::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(loc_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->a->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("a"), x0));

  return out_node;
}


hnode_t* loc__Command::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(loc_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->c->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("c"), x0));

  return out_node;
}


hnode_t* loc_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case loc_e::Missing: {
    loc__Missing* obj = static_cast<loc__Missing*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case loc_e::Token: {
    Token* obj = static_cast<Token*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case loc_e::ArgWord: {
    CompoundWord* obj = static_cast<CompoundWord*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case loc_e::WordPart: {
    loc__WordPart* obj = static_cast<loc__WordPart*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case loc_e::Word: {
    loc__Word* obj = static_cast<loc__Word*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case loc_e::Arith: {
    loc__Arith* obj = static_cast<loc__Arith*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case loc_e::Command: {
    loc__Command* obj = static_cast<loc__Command*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}
BigStr* debug_frame_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case debug_frame_e::MainFile:
    v = "MainFile"; break;
  case debug_frame_e::Dummy:
    v = "Dummy"; break;
  case debug_frame_e::Source:
    v = "Source"; break;
  case debug_frame_e::ProcLike:
    v = "ProcLike"; break;
  case debug_frame_e::Token:
    v = "Token"; break;
  case debug_frame_e::CompoundWord:
    v = "CompoundWord"; break;
  case debug_frame_e::BeforeErrTrap:
    v = "BeforeErrTrap"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "debug_frame.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

debug_frame__Dummy* debug_frame::Dummy = &gdebug_frame__Dummy.obj;

GcGlobal<debug_frame__Dummy> gdebug_frame__Dummy = 
  { ObjHeader::Global(debug_frame_e::Dummy) };

hnode_t* debug_frame__MainFile::PrettyTree(bool do_abbrev, Dict<int, bool>*
                                           seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(debug_frame_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = ToPretty(this->main_filename);
  L->append(Alloc<Field>(StrFromC("main_filename"), x0));

  return out_node;
}


hnode_t* debug_frame__Dummy::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(debug_frame_str(this->tag()));
  return out_node;
}


hnode_t* debug_frame__Source::PrettyTree(bool do_abbrev, Dict<int, bool>* seen)
                                         {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(debug_frame_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->source_loc->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("source_loc"), x0));

  hnode_t* x1 = ToPretty(this->source_name);
  L->append(Alloc<Field>(StrFromC("source_name"), x1));

  return out_node;
}


hnode_t* debug_frame__ProcLike::PrettyTree(bool do_abbrev, Dict<int, bool>*
                                           seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(debug_frame_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->invoke_loc->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("invoke_loc"), x0));

  hnode_t* x1 = this->def_tok->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("def_tok"), x1));

  hnode_t* x2 = ToPretty(this->proc_name);
  L->append(Alloc<Field>(StrFromC("proc_name"), x2));

  return out_node;
}


hnode_t* debug_frame__BeforeErrTrap::PrettyTree(bool do_abbrev, Dict<int,
                                                bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(debug_frame_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->tok->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("tok"), x0));

  return out_node;
}


hnode_t* debug_frame_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case debug_frame_e::MainFile: {
    debug_frame__MainFile* obj = static_cast<debug_frame__MainFile*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case debug_frame_e::Dummy: {
    debug_frame__Dummy* obj = static_cast<debug_frame__Dummy*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case debug_frame_e::Source: {
    debug_frame__Source* obj = static_cast<debug_frame__Source*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case debug_frame_e::ProcLike: {
    debug_frame__ProcLike* obj = static_cast<debug_frame__ProcLike*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case debug_frame_e::Token: {
    Token* obj = static_cast<Token*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case debug_frame_e::CompoundWord: {
    CompoundWord* obj = static_cast<CompoundWord*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case debug_frame_e::BeforeErrTrap: {
    debug_frame__BeforeErrTrap* obj =
static_cast<debug_frame__BeforeErrTrap*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}
BigStr* bracket_op_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case bracket_op_e::WholeArray:
    v = "WholeArray"; break;
  case bracket_op_e::ArrayIndex:
    v = "ArrayIndex"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "bracket_op.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

hnode_t* bracket_op__WholeArray::PrettyTree(bool do_abbrev, Dict<int, bool>*
                                            seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(bracket_op_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = Alloc<hnode::Leaf>(Id_str(this->op_id, false),
                                   color_e::UserType);
  L->append(Alloc<Field>(StrFromC("op_id"), x0));

  return out_node;
}


hnode_t* bracket_op__ArrayIndex::PrettyTree(bool do_abbrev, Dict<int, bool>*
                                            seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(bracket_op_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->expr->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("expr"), x0));

  return out_node;
}


hnode_t* bracket_op_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case bracket_op_e::WholeArray: {
    bracket_op__WholeArray* obj = static_cast<bracket_op__WholeArray*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case bracket_op_e::ArrayIndex: {
    bracket_op__ArrayIndex* obj = static_cast<bracket_op__ArrayIndex*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}
BigStr* suffix_op_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case suffix_op_e::Nullary:
    v = "Nullary"; break;
  case suffix_op_e::Unary:
    v = "Unary"; break;
  case suffix_op_e::Static:
    v = "Static"; break;
  case suffix_op_e::PatSub:
    v = "PatSub"; break;
  case suffix_op_e::Slice:
    v = "Slice"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "suffix_op.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

hnode_t* suffix_op__Unary::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(suffix_op_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->op->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("op"), x0));

  hnode_t* x1 = this->arg_word->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("arg_word"), x1));

  return out_node;
}


hnode_t* suffix_op__Static::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(suffix_op_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->tok->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("tok"), x0));

  hnode_t* x1 = ToPretty(this->arg);
  L->append(Alloc<Field>(StrFromC("arg"), x1));

  return out_node;
}


hnode_t* suffix_op__PatSub::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(suffix_op_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->pat->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("pat"), x0));

  hnode_t* x1 = this->replace->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("replace"), x1));

  hnode_t* x2 = Alloc<hnode::Leaf>(Id_str(this->replace_mode, false),
                                   color_e::UserType);
  L->append(Alloc<Field>(StrFromC("replace_mode"), x2));

  hnode_t* x3 = this->slash_tok->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("slash_tok"), x3));

  return out_node;
}


hnode_t* suffix_op__Slice::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(suffix_op_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->begin->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("begin"), x0));

  if (this->length) {  // Optional
    hnode_t* x1 = this->length->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("length"), x1));
  }

  return out_node;
}


hnode_t* suffix_op_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case suffix_op_e::Nullary: {
    Token* obj = static_cast<Token*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case suffix_op_e::Unary: {
    suffix_op__Unary* obj = static_cast<suffix_op__Unary*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case suffix_op_e::Static: {
    suffix_op__Static* obj = static_cast<suffix_op__Static*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case suffix_op_e::PatSub: {
    suffix_op__PatSub* obj = static_cast<suffix_op__PatSub*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case suffix_op_e::Slice: {
    suffix_op__Slice* obj = static_cast<suffix_op__Slice*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}

hnode_t* BracedVarSub::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  if (do_abbrev) {
    auto* p = syntax_abbrev::_BracedVarSub(this);
    if (p) {
      return p;
    }
  }
  hnode::Record* out_node = runtime::NewRecord(StrFromC("BracedVarSub"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  hnode_t* x1 = this->name_tok->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("name_tok"), x1));

  hnode_t* x2 = ToPretty(this->var_name);
  L->append(Alloc<Field>(StrFromC("var_name"), x2));

  if (this->prefix_op) {  // Optional
    hnode_t* x3 = this->prefix_op->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("prefix_op"), x3));
  }

  if (this->bracket_op) {  // Optional
    hnode_t* x4 = this->bracket_op->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("bracket_op"), x4));
  }

  if (this->suffix_op) {  // Optional
    hnode_t* x5 = this->suffix_op->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("suffix_op"), x5));
  }

  hnode_t* x6 = this->right->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("right"), x6));

  return out_node;
}


hnode_t* DoubleQuoted::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  if (do_abbrev) {
    auto* p = syntax_abbrev::_DoubleQuoted(this);
    if (p) {
      return p;
    }
  }
  hnode::Record* out_node = runtime::NewRecord(StrFromC("DoubleQuoted"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  if (this->parts != nullptr) {  // List
    hnode::Array* x1 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<word_part_t*> it(this->parts); !it.Done(); it.Next()) {
      word_part_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x1->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("parts"), x1));
  }

  hnode_t* x2 = this->right->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("right"), x2));

  return out_node;
}


hnode_t* SingleQuoted::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  if (do_abbrev) {
    auto* p = syntax_abbrev::_SingleQuoted(this);
    if (p) {
      return p;
    }
  }
  hnode::Record* out_node = runtime::NewRecord(StrFromC("SingleQuoted"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  hnode_t* x1 = ToPretty(this->sval);
  L->append(Alloc<Field>(StrFromC("sval"), x1));

  hnode_t* x2 = this->right->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("right"), x2));

  return out_node;
}


hnode_t* SimpleVarSub::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  if (do_abbrev) {
    auto* p = syntax_abbrev::_SimpleVarSub(this);
    if (p) {
      return p;
    }
  }
  hnode::Record* out_node = runtime::NewRecord(StrFromC("SimpleVarSub"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->tok->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("tok"), x0));

  return out_node;
}


hnode_t* CommandSub::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("CommandSub"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left_token->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left_token"), x0));

  hnode_t* x1 = this->child->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("child"), x1));

  hnode_t* x2 = this->right->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("right"), x2));

  return out_node;
}


hnode_t* ExprSub::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("ExprSub"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  hnode_t* x1 = this->child->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("child"), x1));

  hnode_t* x2 = this->right->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("right"), x2));

  return out_node;
}


hnode_t* YshArrayLiteral::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("YshArrayLiteral"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  if (this->words != nullptr) {  // List
    hnode::Array* x1 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<word_t*> it(this->words); !it.Done(); it.Next()) {
      word_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x1->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("words"), x1));
  }

  hnode_t* x2 = this->right->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("right"), x2));

  return out_node;
}


hnode_t* ArgList::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("ArgList"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  if (this->pos_args != nullptr) {  // List
    hnode::Array* x1 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<expr_t*> it(this->pos_args); !it.Done(); it.Next()) {
      expr_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x1->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("pos_args"), x1));
  }

  if (this->semi_tok) {  // Optional
    hnode_t* x2 = this->semi_tok->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("semi_tok"), x2));
  }

  if (this->named_args != nullptr) {  // List
    hnode::Array* x3 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<NamedArg*> it(this->named_args); !it.Done(); it.Next()) {
      NamedArg* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x3->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("named_args"), x3));
  }

  if (this->semi_tok2) {  // Optional
    hnode_t* x4 = this->semi_tok2->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("semi_tok2"), x4));
  }

  if (this->block_expr) {  // Optional
    hnode_t* x5 = this->block_expr->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("block_expr"), x5));
  }

  hnode_t* x6 = this->right->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("right"), x6));

  return out_node;
}


hnode_t* AssocPair::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("AssocPair"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->key->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("key"), x0));

  hnode_t* x1 = this->value->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("value"), x1));

  hnode_t* x2 = ToPretty(this->has_plus);
  L->append(Alloc<Field>(StrFromC("has_plus"), x2));

  return out_node;
}

BigStr* InitializerWord_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case InitializerWord_e::ArrayWord:
    v = "ArrayWord"; break;
  case InitializerWord_e::AssocPair:
    v = "AssocPair"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "InitializerWord.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

hnode_t* InitializerWord__ArrayWord::PrettyTree(bool do_abbrev, Dict<int,
                                                bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node =
runtime::NewRecord(InitializerWord_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->w->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("w"), x0));

  return out_node;
}


hnode_t* InitializerWord_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case InitializerWord_e::ArrayWord: {
    InitializerWord__ArrayWord* obj =
static_cast<InitializerWord__ArrayWord*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case InitializerWord_e::AssocPair: {
    AssocPair* obj = static_cast<AssocPair*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}
BigStr* word_part_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case word_part_e::YshArrayLiteral:
    v = "YshArrayLiteral"; break;
  case word_part_e::InitializerLiteral:
    v = "InitializerLiteral"; break;
  case word_part_e::Literal:
    v = "Literal"; break;
  case word_part_e::EscapedLiteral:
    v = "EscapedLiteral"; break;
  case word_part_e::SingleQuoted:
    v = "SingleQuoted"; break;
  case word_part_e::DoubleQuoted:
    v = "DoubleQuoted"; break;
  case word_part_e::SimpleVarSub:
    v = "SimpleVarSub"; break;
  case word_part_e::BracedVarSub:
    v = "BracedVarSub"; break;
  case word_part_e::ZshVarSub:
    v = "ZshVarSub"; break;
  case word_part_e::CommandSub:
    v = "CommandSub"; break;
  case word_part_e::TildeSub:
    v = "TildeSub"; break;
  case word_part_e::ArithSub:
    v = "ArithSub"; break;
  case word_part_e::BracedTuple:
    v = "BracedTuple"; break;
  case word_part_e::BracedRange:
    v = "BracedRange"; break;
  case word_part_e::BracedRangeDigit:
    v = "BracedRangeDigit"; break;
  case word_part_e::ExtGlob:
    v = "ExtGlob"; break;
  case word_part_e::BashRegexGroup:
    v = "BashRegexGroup"; break;
  case word_part_e::Splice:
    v = "Splice"; break;
  case word_part_e::ExprSub:
    v = "ExprSub"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "word_part.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

hnode_t* word_part__InitializerLiteral::PrettyTree(bool do_abbrev, Dict<int,
                                                   bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(word_part_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  if (this->pairs != nullptr) {  // List
    hnode::Array* x1 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<InitializerWord_t*> it(this->pairs); !it.Done(); it.Next()) {
      InitializerWord_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x1->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("pairs"), x1));
  }

  hnode_t* x2 = this->right->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("right"), x2));

  return out_node;
}


hnode_t* word_part__EscapedLiteral::PrettyTree(bool do_abbrev, Dict<int, bool>*
                                               seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(word_part_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->token->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("token"), x0));

  hnode_t* x1 = ToPretty(this->ch);
  L->append(Alloc<Field>(StrFromC("ch"), x1));

  return out_node;
}


hnode_t* word_part__ZshVarSub::PrettyTree(bool do_abbrev, Dict<int, bool>*
                                          seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(word_part_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  hnode_t* x1 = this->ignored->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("ignored"), x1));

  hnode_t* x2 = this->right->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("right"), x2));

  return out_node;
}


hnode_t* word_part__TildeSub::PrettyTree(bool do_abbrev, Dict<int, bool>* seen)
                                         {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(word_part_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  if (this->name) {  // Optional
    hnode_t* x1 = this->name->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("name"), x1));
  }

  if (this->user_name) {  // Optional
    hnode_t* x2 = ToPretty(this->user_name);
    L->append(Alloc<Field>(StrFromC("user_name"), x2));
  }

  return out_node;
}


hnode_t* word_part__ArithSub::PrettyTree(bool do_abbrev, Dict<int, bool>* seen)
                                         {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(word_part_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  hnode_t* x1 = this->anode->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("anode"), x1));

  hnode_t* x2 = this->right->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("right"), x2));

  return out_node;
}


hnode_t* word_part__BracedTuple::PrettyTree(bool do_abbrev, Dict<int, bool>*
                                            seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(word_part_str(this->tag()));
  List<Field*>* L = out_node->fields;

  if (this->words != nullptr) {  // List
    hnode::Array* x0 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<CompoundWord*> it(this->words); !it.Done(); it.Next()) {
      CompoundWord* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x0->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("words"), x0));
  }

  return out_node;
}


hnode_t* word_part__BracedRange::PrettyTree(bool do_abbrev, Dict<int, bool>*
                                            seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(word_part_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->blame_tok->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("blame_tok"), x0));

  hnode_t* x1 = Alloc<hnode::Leaf>(Id_str(this->kind, false),
                                   color_e::UserType);
  L->append(Alloc<Field>(StrFromC("kind"), x1));

  hnode_t* x2 = ToPretty(this->start);
  L->append(Alloc<Field>(StrFromC("start"), x2));

  hnode_t* x3 = ToPretty(this->end);
  L->append(Alloc<Field>(StrFromC("end"), x3));

  hnode_t* x4 = ToPretty(this->step);
  L->append(Alloc<Field>(StrFromC("step"), x4));

  return out_node;
}


hnode_t* word_part__BracedRangeDigit::PrettyTree(bool do_abbrev, Dict<int,
                                                 bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(word_part_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = ToPretty(this->s);
  L->append(Alloc<Field>(StrFromC("s"), x0));

  hnode_t* x1 = this->orig_tok->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("orig_tok"), x1));

  return out_node;
}


hnode_t* word_part__ExtGlob::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(word_part_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->op->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("op"), x0));

  if (this->arms != nullptr) {  // List
    hnode::Array* x1 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<CompoundWord*> it(this->arms); !it.Done(); it.Next()) {
      CompoundWord* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x1->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("arms"), x1));
  }

  hnode_t* x2 = this->right->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("right"), x2));

  return out_node;
}


hnode_t* word_part__BashRegexGroup::PrettyTree(bool do_abbrev, Dict<int, bool>*
                                               seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(word_part_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  if (this->child) {  // Optional
    hnode_t* x1 = this->child->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("child"), x1));
  }

  hnode_t* x2 = this->right->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("right"), x2));

  return out_node;
}


hnode_t* word_part__Splice::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(word_part_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->blame_tok->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("blame_tok"), x0));

  hnode_t* x1 = ToPretty(this->var_name);
  L->append(Alloc<Field>(StrFromC("var_name"), x1));

  return out_node;
}


hnode_t* word_part_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case word_part_e::YshArrayLiteral: {
    YshArrayLiteral* obj = static_cast<YshArrayLiteral*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case word_part_e::InitializerLiteral: {
    word_part__InitializerLiteral* obj =
static_cast<word_part__InitializerLiteral*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case word_part_e::Literal: {
    Token* obj = static_cast<Token*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case word_part_e::EscapedLiteral: {
    word_part__EscapedLiteral* obj =
static_cast<word_part__EscapedLiteral*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case word_part_e::SingleQuoted: {
    SingleQuoted* obj = static_cast<SingleQuoted*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case word_part_e::DoubleQuoted: {
    DoubleQuoted* obj = static_cast<DoubleQuoted*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case word_part_e::SimpleVarSub: {
    SimpleVarSub* obj = static_cast<SimpleVarSub*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case word_part_e::BracedVarSub: {
    BracedVarSub* obj = static_cast<BracedVarSub*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case word_part_e::ZshVarSub: {
    word_part__ZshVarSub* obj = static_cast<word_part__ZshVarSub*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case word_part_e::CommandSub: {
    CommandSub* obj = static_cast<CommandSub*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case word_part_e::TildeSub: {
    word_part__TildeSub* obj = static_cast<word_part__TildeSub*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case word_part_e::ArithSub: {
    word_part__ArithSub* obj = static_cast<word_part__ArithSub*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case word_part_e::BracedTuple: {
    word_part__BracedTuple* obj = static_cast<word_part__BracedTuple*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case word_part_e::BracedRange: {
    word_part__BracedRange* obj = static_cast<word_part__BracedRange*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case word_part_e::BracedRangeDigit: {
    word_part__BracedRangeDigit* obj =
static_cast<word_part__BracedRangeDigit*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case word_part_e::ExtGlob: {
    word_part__ExtGlob* obj = static_cast<word_part__ExtGlob*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case word_part_e::BashRegexGroup: {
    word_part__BashRegexGroup* obj =
static_cast<word_part__BashRegexGroup*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case word_part_e::Splice: {
    word_part__Splice* obj = static_cast<word_part__Splice*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case word_part_e::ExprSub: {
    ExprSub* obj = static_cast<ExprSub*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}
BigStr* rhs_word_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case rhs_word_e::Empty:
    v = "Empty"; break;
  case rhs_word_e::Compound:
    v = "Compound"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "rhs_word.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

rhs_word__Empty* rhs_word::Empty = &grhs_word__Empty.obj;

GcGlobal<rhs_word__Empty> grhs_word__Empty = 
  { ObjHeader::Global(rhs_word_e::Empty) };

hnode_t* rhs_word__Empty::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(rhs_word_str(this->tag()));
  return out_node;
}


hnode_t* rhs_word_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case rhs_word_e::Empty: {
    rhs_word__Empty* obj = static_cast<rhs_word__Empty*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case rhs_word_e::Compound: {
    CompoundWord* obj = static_cast<CompoundWord*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}
BigStr* word_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case word_e::Operator:
    v = "Operator"; break;
  case word_e::Compound:
    v = "Compound"; break;
  case word_e::BracedTree:
    v = "BracedTree"; break;
  case word_e::String:
    v = "String"; break;
  case word_e::Redir:
    v = "Redir"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "word.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

hnode_t* word__BracedTree::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(word_str(this->tag()));
  List<Field*>* L = out_node->fields;

  if (this->parts != nullptr) {  // List
    hnode::Array* x0 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<word_part_t*> it(this->parts); !it.Done(); it.Next()) {
      word_part_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x0->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("parts"), x0));
  }

  return out_node;
}


hnode_t* word__String::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(word_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = Alloc<hnode::Leaf>(Id_str(this->id, false), color_e::UserType);
  L->append(Alloc<Field>(StrFromC("id"), x0));

  hnode_t* x1 = ToPretty(this->s);
  L->append(Alloc<Field>(StrFromC("s"), x1));

  if (this->blame_loc) {  // Optional
    hnode_t* x2 = this->blame_loc->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("blame_loc"), x2));
  }

  return out_node;
}


hnode_t* word__Redir::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(word_str(this->tag()));
  List<Field*>* L = out_node->fields;

  if (this->left_tok) {  // Optional
    hnode_t* x0 = this->left_tok->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("left_tok"), x0));
  }

  hnode_t* x1 = this->op->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("op"), x1));

  return out_node;
}


hnode_t* word_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case word_e::Operator: {
    Token* obj = static_cast<Token*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case word_e::Compound: {
    CompoundWord* obj = static_cast<CompoundWord*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case word_e::BracedTree: {
    word__BracedTree* obj = static_cast<word__BracedTree*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case word_e::String: {
    word__String* obj = static_cast<word__String*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case word_e::Redir: {
    word__Redir* obj = static_cast<word__Redir*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}
BigStr* sh_lhs_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case sh_lhs_e::Name:
    v = "Name"; break;
  case sh_lhs_e::IndexedName:
    v = "IndexedName"; break;
  case sh_lhs_e::UnparsedIndex:
    v = "UnparsedIndex"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "sh_lhs.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

hnode_t* sh_lhs__Name::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(sh_lhs_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  hnode_t* x1 = ToPretty(this->name);
  L->append(Alloc<Field>(StrFromC("name"), x1));

  return out_node;
}


hnode_t* sh_lhs__IndexedName::PrettyTree(bool do_abbrev, Dict<int, bool>* seen)
                                         {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(sh_lhs_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  hnode_t* x1 = ToPretty(this->name);
  L->append(Alloc<Field>(StrFromC("name"), x1));

  hnode_t* x2 = this->index->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("index"), x2));

  return out_node;
}


hnode_t* sh_lhs__UnparsedIndex::PrettyTree(bool do_abbrev, Dict<int, bool>*
                                           seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(sh_lhs_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  hnode_t* x1 = ToPretty(this->name);
  L->append(Alloc<Field>(StrFromC("name"), x1));

  hnode_t* x2 = ToPretty(this->index);
  L->append(Alloc<Field>(StrFromC("index"), x2));

  return out_node;
}


hnode_t* sh_lhs_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case sh_lhs_e::Name: {
    sh_lhs__Name* obj = static_cast<sh_lhs__Name*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case sh_lhs_e::IndexedName: {
    sh_lhs__IndexedName* obj = static_cast<sh_lhs__IndexedName*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case sh_lhs_e::UnparsedIndex: {
    sh_lhs__UnparsedIndex* obj = static_cast<sh_lhs__UnparsedIndex*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}
BigStr* arith_expr_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case arith_expr_e::EmptyZero:
    v = "EmptyZero"; break;
  case arith_expr_e::EmptyOne:
    v = "EmptyOne"; break;
  case arith_expr_e::VarSub:
    v = "VarSub"; break;
  case arith_expr_e::Word:
    v = "Word"; break;
  case arith_expr_e::UnaryAssign:
    v = "UnaryAssign"; break;
  case arith_expr_e::BinaryAssign:
    v = "BinaryAssign"; break;
  case arith_expr_e::Unary:
    v = "Unary"; break;
  case arith_expr_e::Binary:
    v = "Binary"; break;
  case arith_expr_e::TernaryOp:
    v = "TernaryOp"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "arith_expr.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

arith_expr__EmptyZero* arith_expr::EmptyZero = &garith_expr__EmptyZero.obj;

GcGlobal<arith_expr__EmptyZero> garith_expr__EmptyZero = 
  { ObjHeader::Global(arith_expr_e::EmptyZero) };

arith_expr__EmptyOne* arith_expr::EmptyOne = &garith_expr__EmptyOne.obj;

GcGlobal<arith_expr__EmptyOne> garith_expr__EmptyOne = 
  { ObjHeader::Global(arith_expr_e::EmptyOne) };

hnode_t* arith_expr__EmptyZero::PrettyTree(bool do_abbrev, Dict<int, bool>*
                                           seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(arith_expr_str(this->tag()));
  return out_node;
}


hnode_t* arith_expr__EmptyOne::PrettyTree(bool do_abbrev, Dict<int, bool>*
                                          seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(arith_expr_str(this->tag()));
  return out_node;
}


hnode_t* arith_expr__UnaryAssign::PrettyTree(bool do_abbrev, Dict<int, bool>*
                                             seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(arith_expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = Alloc<hnode::Leaf>(Id_str(this->op_id, false),
                                   color_e::UserType);
  L->append(Alloc<Field>(StrFromC("op_id"), x0));

  hnode_t* x1 = this->child->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("child"), x1));

  return out_node;
}


hnode_t* arith_expr__BinaryAssign::PrettyTree(bool do_abbrev, Dict<int, bool>*
                                              seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(arith_expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = Alloc<hnode::Leaf>(Id_str(this->op_id, false),
                                   color_e::UserType);
  L->append(Alloc<Field>(StrFromC("op_id"), x0));

  hnode_t* x1 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x1));

  hnode_t* x2 = this->right->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("right"), x2));

  return out_node;
}


hnode_t* arith_expr__Unary::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(arith_expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = Alloc<hnode::Leaf>(Id_str(this->op_id, false),
                                   color_e::UserType);
  L->append(Alloc<Field>(StrFromC("op_id"), x0));

  hnode_t* x1 = this->child->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("child"), x1));

  return out_node;
}


hnode_t* arith_expr__Binary::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(arith_expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->op->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("op"), x0));

  hnode_t* x1 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x1));

  hnode_t* x2 = this->right->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("right"), x2));

  return out_node;
}


hnode_t* arith_expr__TernaryOp::PrettyTree(bool do_abbrev, Dict<int, bool>*
                                           seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(arith_expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->cond->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("cond"), x0));

  hnode_t* x1 = this->true_expr->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("true_expr"), x1));

  hnode_t* x2 = this->false_expr->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("false_expr"), x2));

  return out_node;
}


hnode_t* arith_expr_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case arith_expr_e::EmptyZero: {
    arith_expr__EmptyZero* obj = static_cast<arith_expr__EmptyZero*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case arith_expr_e::EmptyOne: {
    arith_expr__EmptyOne* obj = static_cast<arith_expr__EmptyOne*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case arith_expr_e::VarSub: {
    Token* obj = static_cast<Token*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case arith_expr_e::Word: {
    CompoundWord* obj = static_cast<CompoundWord*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case arith_expr_e::UnaryAssign: {
    arith_expr__UnaryAssign* obj = static_cast<arith_expr__UnaryAssign*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case arith_expr_e::BinaryAssign: {
    arith_expr__BinaryAssign* obj =
static_cast<arith_expr__BinaryAssign*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case arith_expr_e::Unary: {
    arith_expr__Unary* obj = static_cast<arith_expr__Unary*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case arith_expr_e::Binary: {
    arith_expr__Binary* obj = static_cast<arith_expr__Binary*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case arith_expr_e::TernaryOp: {
    arith_expr__TernaryOp* obj = static_cast<arith_expr__TernaryOp*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}
BigStr* bool_expr_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case bool_expr_e::WordTest:
    v = "WordTest"; break;
  case bool_expr_e::Binary:
    v = "Binary"; break;
  case bool_expr_e::Unary:
    v = "Unary"; break;
  case bool_expr_e::LogicalNot:
    v = "LogicalNot"; break;
  case bool_expr_e::LogicalAnd:
    v = "LogicalAnd"; break;
  case bool_expr_e::LogicalOr:
    v = "LogicalOr"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "bool_expr.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

hnode_t* bool_expr__WordTest::PrettyTree(bool do_abbrev, Dict<int, bool>* seen)
                                         {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(bool_expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->w->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("w"), x0));

  return out_node;
}


hnode_t* bool_expr__Binary::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(bool_expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = Alloc<hnode::Leaf>(Id_str(this->op_id, false),
                                   color_e::UserType);
  L->append(Alloc<Field>(StrFromC("op_id"), x0));

  hnode_t* x1 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x1));

  hnode_t* x2 = this->right->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("right"), x2));

  return out_node;
}


hnode_t* bool_expr__Unary::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(bool_expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = Alloc<hnode::Leaf>(Id_str(this->op_id, false),
                                   color_e::UserType);
  L->append(Alloc<Field>(StrFromC("op_id"), x0));

  hnode_t* x1 = this->child->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("child"), x1));

  return out_node;
}


hnode_t* bool_expr__LogicalNot::PrettyTree(bool do_abbrev, Dict<int, bool>*
                                           seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(bool_expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->child->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("child"), x0));

  return out_node;
}


hnode_t* bool_expr__LogicalAnd::PrettyTree(bool do_abbrev, Dict<int, bool>*
                                           seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(bool_expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  hnode_t* x1 = this->right->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("right"), x1));

  return out_node;
}


hnode_t* bool_expr__LogicalOr::PrettyTree(bool do_abbrev, Dict<int, bool>*
                                          seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(bool_expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  hnode_t* x1 = this->right->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("right"), x1));

  return out_node;
}


hnode_t* bool_expr_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case bool_expr_e::WordTest: {
    bool_expr__WordTest* obj = static_cast<bool_expr__WordTest*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case bool_expr_e::Binary: {
    bool_expr__Binary* obj = static_cast<bool_expr__Binary*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case bool_expr_e::Unary: {
    bool_expr__Unary* obj = static_cast<bool_expr__Unary*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case bool_expr_e::LogicalNot: {
    bool_expr__LogicalNot* obj = static_cast<bool_expr__LogicalNot*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case bool_expr_e::LogicalAnd: {
    bool_expr__LogicalAnd* obj = static_cast<bool_expr__LogicalAnd*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case bool_expr_e::LogicalOr: {
    bool_expr__LogicalOr* obj = static_cast<bool_expr__LogicalOr*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}
BigStr* redir_loc_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case redir_loc_e::Fd:
    v = "Fd"; break;
  case redir_loc_e::VarName:
    v = "VarName"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "redir_loc.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

hnode_t* redir_loc__Fd::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(redir_loc_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = ToPretty(this->fd);
  L->append(Alloc<Field>(StrFromC("fd"), x0));

  return out_node;
}


hnode_t* redir_loc__VarName::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(redir_loc_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = ToPretty(this->name);
  L->append(Alloc<Field>(StrFromC("name"), x0));

  return out_node;
}


hnode_t* redir_loc_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case redir_loc_e::Fd: {
    redir_loc__Fd* obj = static_cast<redir_loc__Fd*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case redir_loc_e::VarName: {
    redir_loc__VarName* obj = static_cast<redir_loc__VarName*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}
BigStr* redir_param_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case redir_param_e::Word:
    v = "Word"; break;
  case redir_param_e::HereWord:
    v = "HereWord"; break;
  case redir_param_e::HereDoc:
    v = "HereDoc"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "redir_param.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

hnode_t* redir_param__HereWord::PrettyTree(bool do_abbrev, Dict<int, bool>*
                                           seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(redir_param_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->w->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("w"), x0));

  hnode_t* x1 = ToPretty(this->is_multiline);
  L->append(Alloc<Field>(StrFromC("is_multiline"), x1));

  return out_node;
}


hnode_t* redir_param__HereDoc::PrettyTree(bool do_abbrev, Dict<int, bool>*
                                          seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(redir_param_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->here_begin->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("here_begin"), x0));

  if (this->here_end_tok) {  // Optional
    hnode_t* x1 = this->here_end_tok->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("here_end_tok"), x1));
  }

  if (this->stdin_parts != nullptr) {  // List
    hnode::Array* x2 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<word_part_t*> it(this->stdin_parts); !it.Done(); it.Next()) {
      word_part_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x2->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("stdin_parts"), x2));
  }

  return out_node;
}


hnode_t* redir_param_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case redir_param_e::Word: {
    CompoundWord* obj = static_cast<CompoundWord*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case redir_param_e::HereWord: {
    redir_param__HereWord* obj = static_cast<redir_param__HereWord*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case redir_param_e::HereDoc: {
    redir_param__HereDoc* obj = static_cast<redir_param__HereDoc*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}

hnode_t* Redir::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("Redir"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->op->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("op"), x0));

  hnode_t* x1 = this->loc->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("loc"), x1));

  hnode_t* x2 = this->arg->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("arg"), x2));

  return out_node;
}

BigStr* assign_op_str(assign_op_e tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case assign_op_e::Equal:
    v = "Equal"; break;
  case assign_op_e::PlusEqual:
    v = "PlusEqual"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "assign_op.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

hnode_t* AssignPair::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("AssignPair"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  hnode_t* x1 = this->lhs->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("lhs"), x1));

  hnode_t* x2 = Alloc<hnode::Leaf>(assign_op_str(this->op), color_e::TypeName);
  L->append(Alloc<Field>(StrFromC("op"), x2));

  hnode_t* x3 = this->rhs->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("rhs"), x3));

  return out_node;
}


hnode_t* EnvPair::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("EnvPair"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  hnode_t* x1 = ToPretty(this->name);
  L->append(Alloc<Field>(StrFromC("name"), x1));

  hnode_t* x2 = this->val->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("val"), x2));

  return out_node;
}


hnode_t* List_of_command::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Array* out_node = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
  for (ListIter<command_t*> it(this); !it.Done(); it.Next()) {
    command_t* v_ = it.Value();
    hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                  color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
    out_node->children->append(h);
  }
  return out_node;
}

BigStr* condition_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case condition_e::Shell:
    v = "Shell"; break;
  case condition_e::YshExpr:
    v = "YshExpr"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "condition.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

hnode_t* condition__YshExpr::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(condition_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->e->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("e"), x0));

  return out_node;
}


hnode_t* condition_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case condition_e::Shell: {
    List_of_command* obj = static_cast<List_of_command*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case condition_e::YshExpr: {
    condition__YshExpr* obj = static_cast<condition__YshExpr*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}

hnode_t* CaseArm::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("CaseArm"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  hnode_t* x1 = this->pattern->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("pattern"), x1));

  hnode_t* x2 = this->middle->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("middle"), x2));

  if (this->action != nullptr) {  // List
    hnode::Array* x3 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<command_t*> it(this->action); !it.Done(); it.Next()) {
      command_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x3->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("action"), x3));
  }

  if (this->right) {  // Optional
    hnode_t* x4 = this->right->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("right"), x4));
  }

  return out_node;
}

BigStr* case_arg_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case case_arg_e::Word:
    v = "Word"; break;
  case case_arg_e::YshExpr:
    v = "YshExpr"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "case_arg.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

hnode_t* case_arg__Word::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(case_arg_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->w->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("w"), x0));

  return out_node;
}


hnode_t* case_arg__YshExpr::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(case_arg_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->e->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("e"), x0));

  return out_node;
}


hnode_t* case_arg_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case case_arg_e::Word: {
    case_arg__Word* obj = static_cast<case_arg__Word*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case case_arg_e::YshExpr: {
    case_arg__YshExpr* obj = static_cast<case_arg__YshExpr*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}

hnode_t* EggexFlag::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("EggexFlag"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = ToPretty(this->negated);
  L->append(Alloc<Field>(StrFromC("negated"), x0));

  hnode_t* x1 = this->flag->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("flag"), x1));

  return out_node;
}


hnode_t* Eggex::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("Eggex"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  hnode_t* x1 = this->regex->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("regex"), x1));

  if (this->flags != nullptr) {  // List
    hnode::Array* x2 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<EggexFlag*> it(this->flags); !it.Done(); it.Next()) {
      EggexFlag* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x2->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("flags"), x2));
  }

  if (this->trans_pref) {  // Optional
    hnode_t* x3 = this->trans_pref->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("trans_pref"), x3));
  }

  if (this->canonical_flags) {  // Optional
    hnode_t* x4 = ToPretty(this->canonical_flags);
    L->append(Alloc<Field>(StrFromC("canonical_flags"), x4));
  }

  return out_node;
}

BigStr* pat_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case pat_e::Else:
    v = "Else"; break;
  case pat_e::Words:
    v = "Words"; break;
  case pat_e::YshExprs:
    v = "YshExprs"; break;
  case pat_e::Eggex:
    v = "Eggex"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "pat.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

pat__Else* pat::Else = &gpat__Else.obj;

GcGlobal<pat__Else> gpat__Else = 
  { ObjHeader::Global(pat_e::Else) };

hnode_t* pat__Else::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(pat_str(this->tag()));
  return out_node;
}


hnode_t* pat__Words::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(pat_str(this->tag()));
  List<Field*>* L = out_node->fields;

  if (this->words != nullptr) {  // List
    hnode::Array* x0 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<word_t*> it(this->words); !it.Done(); it.Next()) {
      word_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x0->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("words"), x0));
  }

  return out_node;
}


hnode_t* pat__YshExprs::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(pat_str(this->tag()));
  List<Field*>* L = out_node->fields;

  if (this->exprs != nullptr) {  // List
    hnode::Array* x0 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<expr_t*> it(this->exprs); !it.Done(); it.Next()) {
      expr_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x0->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("exprs"), x0));
  }

  return out_node;
}


hnode_t* pat_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case pat_e::Else: {
    pat__Else* obj = static_cast<pat__Else*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case pat_e::Words: {
    pat__Words* obj = static_cast<pat__Words*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case pat_e::YshExprs: {
    pat__YshExprs* obj = static_cast<pat__YshExprs*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case pat_e::Eggex: {
    Eggex* obj = static_cast<Eggex*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}

hnode_t* IfArm::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("IfArm"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->keyword->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("keyword"), x0));

  hnode_t* x1 = this->cond->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("cond"), x1));

  if (this->then_kw) {  // Optional
    hnode_t* x2 = this->then_kw->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("then_kw"), x2));
  }

  if (this->action != nullptr) {  // List
    hnode::Array* x3 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<command_t*> it(this->action); !it.Done(); it.Next()) {
      command_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x3->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("action"), x3));
  }

  if (this->then_tok) {  // Optional
    hnode_t* x4 = this->then_tok->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("then_tok"), x4));
  }

  return out_node;
}

BigStr* for_iter_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case for_iter_e::Args:
    v = "Args"; break;
  case for_iter_e::Words:
    v = "Words"; break;
  case for_iter_e::YshExpr:
    v = "YshExpr"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "for_iter.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

for_iter__Args* for_iter::Args = &gfor_iter__Args.obj;

GcGlobal<for_iter__Args> gfor_iter__Args = 
  { ObjHeader::Global(for_iter_e::Args) };

hnode_t* for_iter__Args::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(for_iter_str(this->tag()));
  return out_node;
}


hnode_t* for_iter__Words::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(for_iter_str(this->tag()));
  List<Field*>* L = out_node->fields;

  if (this->words != nullptr) {  // List
    hnode::Array* x0 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<word_t*> it(this->words); !it.Done(); it.Next()) {
      word_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x0->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("words"), x0));
  }

  return out_node;
}


hnode_t* for_iter__YshExpr::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(for_iter_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->e->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("e"), x0));

  hnode_t* x1 = this->blame->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("blame"), x1));

  return out_node;
}


hnode_t* for_iter_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case for_iter_e::Args: {
    for_iter__Args* obj = static_cast<for_iter__Args*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case for_iter_e::Words: {
    for_iter__Words* obj = static_cast<for_iter__Words*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case for_iter_e::YshExpr: {
    for_iter__YshExpr* obj = static_cast<for_iter__YshExpr*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}

hnode_t* BraceGroup::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("BraceGroup"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  if (this->doc_token) {  // Optional
    hnode_t* x1 = this->doc_token->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("doc_token"), x1));
  }

  if (this->children != nullptr) {  // List
    hnode::Array* x2 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<command_t*> it(this->children); !it.Done(); it.Next()) {
      command_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x2->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("children"), x2));
  }

  hnode_t* x3 = this->right->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("right"), x3));

  return out_node;
}


hnode_t* Param::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("Param"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->blame_tok->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("blame_tok"), x0));

  hnode_t* x1 = ToPretty(this->name);
  L->append(Alloc<Field>(StrFromC("name"), x1));

  if (this->type) {  // Optional
    hnode_t* x2 = this->type->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("type"), x2));
  }

  if (this->default_val) {  // Optional
    hnode_t* x3 = this->default_val->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("default_val"), x3));
  }

  return out_node;
}


hnode_t* RestParam::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("RestParam"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->blame_tok->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("blame_tok"), x0));

  hnode_t* x1 = ToPretty(this->name);
  L->append(Alloc<Field>(StrFromC("name"), x1));

  return out_node;
}


hnode_t* ParamGroup::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("ParamGroup"));
  List<Field*>* L = out_node->fields;

  if (this->params != nullptr) {  // List
    hnode::Array* x0 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<Param*> it(this->params); !it.Done(); it.Next()) {
      Param* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x0->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("params"), x0));
  }

  if (this->rest_of) {  // Optional
    hnode_t* x1 = this->rest_of->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("rest_of"), x1));
  }

  return out_node;
}

BigStr* proc_sig_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case proc_sig_e::Open:
    v = "Open"; break;
  case proc_sig_e::Closed:
    v = "Closed"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "proc_sig.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

proc_sig__Open* proc_sig::Open = &gproc_sig__Open.obj;

GcGlobal<proc_sig__Open> gproc_sig__Open = 
  { ObjHeader::Global(proc_sig_e::Open) };

hnode_t* proc_sig__Open::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(proc_sig_str(this->tag()));
  return out_node;
}


hnode_t* proc_sig__Closed::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(proc_sig_str(this->tag()));
  List<Field*>* L = out_node->fields;

  if (this->word) {  // Optional
    hnode_t* x0 = this->word->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("word"), x0));
  }

  if (this->positional) {  // Optional
    hnode_t* x1 = this->positional->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("positional"), x1));
  }

  if (this->named) {  // Optional
    hnode_t* x2 = this->named->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("named"), x2));
  }

  if (this->block_param) {  // Optional
    hnode_t* x3 = this->block_param->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("block_param"), x3));
  }

  return out_node;
}


hnode_t* proc_sig_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case proc_sig_e::Open: {
    proc_sig__Open* obj = static_cast<proc_sig__Open*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case proc_sig_e::Closed: {
    proc_sig__Closed* obj = static_cast<proc_sig__Closed*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}

hnode_t* Proc::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("Proc"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->keyword->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("keyword"), x0));

  hnode_t* x1 = this->name->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("name"), x1));

  hnode_t* x2 = this->sig->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("sig"), x2));

  hnode_t* x3 = this->body->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("body"), x3));

  return out_node;
}


hnode_t* Func::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("Func"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->keyword->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("keyword"), x0));

  hnode_t* x1 = this->name->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("name"), x1));

  if (this->positional) {  // Optional
    hnode_t* x2 = this->positional->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("positional"), x2));
  }

  if (this->named) {  // Optional
    hnode_t* x3 = this->named->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("named"), x3));
  }

  hnode_t* x4 = this->body->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("body"), x4));

  return out_node;
}


hnode_t* ParsedAssignment::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("ParsedAssignment"));
  List<Field*>* L = out_node->fields;

  if (this->left) {  // Optional
    hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("left"), x0));
  }

  if (this->close) {  // Optional
    hnode_t* x1 = this->close->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("close"), x1));
  }

  hnode_t* x2 = ToPretty(this->part_offset);
  L->append(Alloc<Field>(StrFromC("part_offset"), x2));

  hnode_t* x3 = this->w->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("w"), x3));

  return out_node;
}


hnode_t* VarDecl::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("VarDecl"));
  List<Field*>* L = out_node->fields;

  if (this->keyword) {  // Optional
    hnode_t* x0 = this->keyword->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("keyword"), x0));
  }

  if (this->lhs != nullptr) {  // List
    hnode::Array* x1 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<NameType*> it(this->lhs); !it.Done(); it.Next()) {
      NameType* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x1->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("lhs"), x1));
  }

  if (this->rhs) {  // Optional
    hnode_t* x2 = this->rhs->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("rhs"), x2));
  }

  return out_node;
}


hnode_t* Mutation::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("Mutation"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->keyword->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("keyword"), x0));

  if (this->lhs != nullptr) {  // List
    hnode::Array* x1 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<y_lhs_t*> it(this->lhs); !it.Done(); it.Next()) {
      y_lhs_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x1->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("lhs"), x1));
  }

  hnode_t* x2 = this->op->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("op"), x2));

  hnode_t* x3 = this->rhs->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("rhs"), x3));

  return out_node;
}


hnode_t* ExprCommand::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("ExprCommand"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->keyword->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("keyword"), x0));

  hnode_t* x1 = this->e->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("e"), x1));

  return out_node;
}


hnode_t* ShFunction::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("ShFunction"));
  List<Field*>* L = out_node->fields;

  if (this->keyword) {  // Optional
    hnode_t* x0 = this->keyword->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("keyword"), x0));
  }

  hnode_t* x1 = this->name_tok->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("name_tok"), x1));

  hnode_t* x2 = ToPretty(this->name);
  L->append(Alloc<Field>(StrFromC("name"), x2));

  hnode_t* x3 = this->body->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("body"), x3));

  if (this->code_str) {  // Optional
    hnode_t* x4 = ToPretty(this->code_str);
    L->append(Alloc<Field>(StrFromC("code_str"), x4));
  }

  return out_node;
}


hnode_t* LiteralBlock::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("LiteralBlock"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->brace_group->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("brace_group"), x0));

  if (this->code_str) {  // Optional
    hnode_t* x1 = ToPretty(this->code_str);
    L->append(Alloc<Field>(StrFromC("code_str"), x1));
  }

  return out_node;
}

BigStr* cmd_frag_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case cmd_frag_e::LiteralBlock:
    v = "LiteralBlock"; break;
  case cmd_frag_e::Expr:
    v = "Expr"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "cmd_frag.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

hnode_t* cmd_frag__Expr::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(cmd_frag_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->c->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("c"), x0));

  return out_node;
}


hnode_t* cmd_frag_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case cmd_frag_e::LiteralBlock: {
    LiteralBlock* obj = static_cast<LiteralBlock*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case cmd_frag_e::Expr: {
    cmd_frag__Expr* obj = static_cast<cmd_frag__Expr*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}
BigStr* command_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case command_e::NoOp:
    v = "NoOp"; break;
  case command_e::Redirect:
    v = "Redirect"; break;
  case command_e::Simple:
    v = "Simple"; break;
  case command_e::ExpandedAlias:
    v = "ExpandedAlias"; break;
  case command_e::Sentence:
    v = "Sentence"; break;
  case command_e::ShAssignment:
    v = "ShAssignment"; break;
  case command_e::ControlFlow:
    v = "ControlFlow"; break;
  case command_e::Pipeline:
    v = "Pipeline"; break;
  case command_e::AndOr:
    v = "AndOr"; break;
  case command_e::DoGroup:
    v = "DoGroup"; break;
  case command_e::BraceGroup:
    v = "BraceGroup"; break;
  case command_e::Subshell:
    v = "Subshell"; break;
  case command_e::DParen:
    v = "DParen"; break;
  case command_e::DBracket:
    v = "DBracket"; break;
  case command_e::ForEach:
    v = "ForEach"; break;
  case command_e::ForExpr:
    v = "ForExpr"; break;
  case command_e::WhileUntil:
    v = "WhileUntil"; break;
  case command_e::If:
    v = "If"; break;
  case command_e::Case:
    v = "Case"; break;
  case command_e::ShFunction:
    v = "ShFunction"; break;
  case command_e::TimeBlock:
    v = "TimeBlock"; break;
  case command_e::CommandList:
    v = "CommandList"; break;
  case command_e::VarDecl:
    v = "VarDecl"; break;
  case command_e::BareDecl:
    v = "BareDecl"; break;
  case command_e::Mutation:
    v = "Mutation"; break;
  case command_e::Expr:
    v = "Expr"; break;
  case command_e::Proc:
    v = "Proc"; break;
  case command_e::Func:
    v = "Func"; break;
  case command_e::Retval:
    v = "Retval"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "command.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

command__NoOp* command::NoOp = &gcommand__NoOp.obj;

GcGlobal<command__NoOp> gcommand__NoOp = 
  { ObjHeader::Global(command_e::NoOp) };

hnode_t* command__NoOp::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(command_str(this->tag()));
  return out_node;
}


hnode_t* command__Redirect::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(command_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->child->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("child"), x0));

  if (this->redirects != nullptr) {  // List
    hnode::Array* x1 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<Redir*> it(this->redirects); !it.Done(); it.Next()) {
      Redir* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x1->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("redirects"), x1));
  }

  return out_node;
}


hnode_t* command__Simple::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  if (do_abbrev) {
    auto* p = syntax_abbrev::_command__Simple(this);
    if (p) {
      return p;
    }
  }
  hnode::Record* out_node = runtime::NewRecord(command_str(this->tag()));
  List<Field*>* L = out_node->fields;

  if (this->blame_tok) {  // Optional
    hnode_t* x0 = this->blame_tok->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("blame_tok"), x0));
  }

  if (this->more_env != nullptr) {  // List
    hnode::Array* x1 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<EnvPair*> it(this->more_env); !it.Done(); it.Next()) {
      EnvPair* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x1->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("more_env"), x1));
  }

  if (this->words != nullptr) {  // List
    hnode::Array* x2 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<word_t*> it(this->words); !it.Done(); it.Next()) {
      word_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x2->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("words"), x2));
  }

  if (this->typed_args) {  // Optional
    hnode_t* x3 = this->typed_args->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("typed_args"), x3));
  }

  if (this->block) {  // Optional
    hnode_t* x4 = this->block->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("block"), x4));
  }

  hnode_t* x5 = ToPretty(this->is_last_cmd);
  L->append(Alloc<Field>(StrFromC("is_last_cmd"), x5));

  if (this->redirects != nullptr) {  // List
    hnode::Array* x6 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<Redir*> it(this->redirects); !it.Done(); it.Next()) {
      Redir* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x6->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("redirects"), x6));
  }

  return out_node;
}


hnode_t* command__ExpandedAlias::PrettyTree(bool do_abbrev, Dict<int, bool>*
                                            seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(command_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->child->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("child"), x0));

  if (this->more_env != nullptr) {  // List
    hnode::Array* x1 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<EnvPair*> it(this->more_env); !it.Done(); it.Next()) {
      EnvPair* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x1->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("more_env"), x1));
  }

  return out_node;
}


hnode_t* command__Sentence::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(command_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->child->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("child"), x0));

  hnode_t* x1 = this->terminator->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("terminator"), x1));

  return out_node;
}


hnode_t* command__ShAssignment::PrettyTree(bool do_abbrev, Dict<int, bool>*
                                           seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(command_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  if (this->pairs != nullptr) {  // List
    hnode::Array* x1 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<AssignPair*> it(this->pairs); !it.Done(); it.Next()) {
      AssignPair* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x1->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("pairs"), x1));
  }

  return out_node;
}


hnode_t* command__ControlFlow::PrettyTree(bool do_abbrev, Dict<int, bool>*
                                          seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(command_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->keyword->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("keyword"), x0));

  if (this->arg_word) {  // Optional
    hnode_t* x1 = this->arg_word->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("arg_word"), x1));
  }

  return out_node;
}


hnode_t* command__Pipeline::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(command_str(this->tag()));
  List<Field*>* L = out_node->fields;

  if (this->negated) {  // Optional
    hnode_t* x0 = this->negated->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("negated"), x0));
  }

  if (this->children != nullptr) {  // List
    hnode::Array* x1 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<command_t*> it(this->children); !it.Done(); it.Next()) {
      command_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x1->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("children"), x1));
  }

  if (this->ops != nullptr) {  // List
    hnode::Array* x2 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<Token*> it(this->ops); !it.Done(); it.Next()) {
      Token* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x2->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("ops"), x2));
  }

  return out_node;
}


hnode_t* command__AndOr::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(command_str(this->tag()));
  List<Field*>* L = out_node->fields;

  if (this->children != nullptr) {  // List
    hnode::Array* x0 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<command_t*> it(this->children); !it.Done(); it.Next()) {
      command_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x0->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("children"), x0));
  }

  if (this->ops != nullptr) {  // List
    hnode::Array* x1 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<Token*> it(this->ops); !it.Done(); it.Next()) {
      Token* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x1->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("ops"), x1));
  }

  return out_node;
}


hnode_t* command__DoGroup::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(command_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  if (this->children != nullptr) {  // List
    hnode::Array* x1 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<command_t*> it(this->children); !it.Done(); it.Next()) {
      command_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x1->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("children"), x1));
  }

  hnode_t* x2 = this->right->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("right"), x2));

  return out_node;
}


hnode_t* command__Subshell::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(command_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  hnode_t* x1 = this->child->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("child"), x1));

  hnode_t* x2 = this->right->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("right"), x2));

  hnode_t* x3 = ToPretty(this->is_last_cmd);
  L->append(Alloc<Field>(StrFromC("is_last_cmd"), x3));

  return out_node;
}


hnode_t* command__DParen::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(command_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  hnode_t* x1 = this->child->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("child"), x1));

  hnode_t* x2 = this->right->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("right"), x2));

  return out_node;
}


hnode_t* command__DBracket::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(command_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  hnode_t* x1 = this->expr->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("expr"), x1));

  hnode_t* x2 = this->right->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("right"), x2));

  return out_node;
}


hnode_t* command__ForEach::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(command_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->keyword->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("keyword"), x0));

  if (this->iter_names != nullptr) {  // List
    hnode::Array* x1 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<BigStr*> it(this->iter_names); !it.Done(); it.Next()) {
      BigStr* v_ = it.Value();
      hnode_t* h = ToPretty(v_);
      x1->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("iter_names"), x1));
  }

  hnode_t* x2 = this->iterable->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("iterable"), x2));

  if (this->semi_tok) {  // Optional
    hnode_t* x3 = this->semi_tok->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("semi_tok"), x3));
  }

  hnode_t* x4 = this->body->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("body"), x4));

  return out_node;
}


hnode_t* command__ForExpr::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(command_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->keyword->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("keyword"), x0));

  if (this->init) {  // Optional
    hnode_t* x1 = this->init->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("init"), x1));
  }

  if (this->cond) {  // Optional
    hnode_t* x2 = this->cond->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("cond"), x2));
  }

  if (this->update) {  // Optional
    hnode_t* x3 = this->update->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("update"), x3));
  }

  if (this->body) {  // Optional
    hnode_t* x4 = this->body->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("body"), x4));
  }

  return out_node;
}


hnode_t* command__WhileUntil::PrettyTree(bool do_abbrev, Dict<int, bool>* seen)
                                         {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(command_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->keyword->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("keyword"), x0));

  hnode_t* x1 = this->cond->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("cond"), x1));

  hnode_t* x2 = this->body->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("body"), x2));

  return out_node;
}


hnode_t* command__If::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(command_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->if_kw->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("if_kw"), x0));

  if (this->arms != nullptr) {  // List
    hnode::Array* x1 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<IfArm*> it(this->arms); !it.Done(); it.Next()) {
      IfArm* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x1->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("arms"), x1));
  }

  if (this->else_kw) {  // Optional
    hnode_t* x2 = this->else_kw->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("else_kw"), x2));
  }

  if (this->else_action != nullptr) {  // List
    hnode::Array* x3 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<command_t*> it(this->else_action); !it.Done(); it.Next()) {
      command_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x3->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("else_action"), x3));
  }

  if (this->fi_kw) {  // Optional
    hnode_t* x4 = this->fi_kw->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("fi_kw"), x4));
  }

  return out_node;
}


hnode_t* command__Case::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(command_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->case_kw->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("case_kw"), x0));

  hnode_t* x1 = this->to_match->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("to_match"), x1));

  hnode_t* x2 = this->arms_start->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("arms_start"), x2));

  if (this->arms != nullptr) {  // List
    hnode::Array* x3 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<CaseArm*> it(this->arms); !it.Done(); it.Next()) {
      CaseArm* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x3->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("arms"), x3));
  }

  hnode_t* x4 = this->arms_end->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("arms_end"), x4));

  return out_node;
}


hnode_t* command__TimeBlock::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(command_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->keyword->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("keyword"), x0));

  hnode_t* x1 = this->pipeline->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("pipeline"), x1));

  return out_node;
}


hnode_t* command__CommandList::PrettyTree(bool do_abbrev, Dict<int, bool>*
                                          seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(command_str(this->tag()));
  List<Field*>* L = out_node->fields;

  if (this->children != nullptr) {  // List
    hnode::Array* x0 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<command_t*> it(this->children); !it.Done(); it.Next()) {
      command_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x0->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("children"), x0));
  }

  return out_node;
}


hnode_t* command__BareDecl::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(command_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->lhs->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("lhs"), x0));

  hnode_t* x1 = this->rhs->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("rhs"), x1));

  return out_node;
}


hnode_t* command__Retval::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(command_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->keyword->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("keyword"), x0));

  hnode_t* x1 = this->val->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("val"), x1));

  return out_node;
}


hnode_t* command_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case command_e::NoOp: {
    command__NoOp* obj = static_cast<command__NoOp*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case command_e::Redirect: {
    command__Redirect* obj = static_cast<command__Redirect*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case command_e::Simple: {
    command__Simple* obj = static_cast<command__Simple*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case command_e::ExpandedAlias: {
    command__ExpandedAlias* obj = static_cast<command__ExpandedAlias*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case command_e::Sentence: {
    command__Sentence* obj = static_cast<command__Sentence*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case command_e::ShAssignment: {
    command__ShAssignment* obj = static_cast<command__ShAssignment*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case command_e::ControlFlow: {
    command__ControlFlow* obj = static_cast<command__ControlFlow*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case command_e::Pipeline: {
    command__Pipeline* obj = static_cast<command__Pipeline*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case command_e::AndOr: {
    command__AndOr* obj = static_cast<command__AndOr*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case command_e::DoGroup: {
    command__DoGroup* obj = static_cast<command__DoGroup*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case command_e::BraceGroup: {
    BraceGroup* obj = static_cast<BraceGroup*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case command_e::Subshell: {
    command__Subshell* obj = static_cast<command__Subshell*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case command_e::DParen: {
    command__DParen* obj = static_cast<command__DParen*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case command_e::DBracket: {
    command__DBracket* obj = static_cast<command__DBracket*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case command_e::ForEach: {
    command__ForEach* obj = static_cast<command__ForEach*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case command_e::ForExpr: {
    command__ForExpr* obj = static_cast<command__ForExpr*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case command_e::WhileUntil: {
    command__WhileUntil* obj = static_cast<command__WhileUntil*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case command_e::If: {
    command__If* obj = static_cast<command__If*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case command_e::Case: {
    command__Case* obj = static_cast<command__Case*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case command_e::ShFunction: {
    ShFunction* obj = static_cast<ShFunction*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case command_e::TimeBlock: {
    command__TimeBlock* obj = static_cast<command__TimeBlock*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case command_e::CommandList: {
    command__CommandList* obj = static_cast<command__CommandList*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case command_e::VarDecl: {
    VarDecl* obj = static_cast<VarDecl*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case command_e::BareDecl: {
    command__BareDecl* obj = static_cast<command__BareDecl*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case command_e::Mutation: {
    Mutation* obj = static_cast<Mutation*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case command_e::Expr: {
    ExprCommand* obj = static_cast<ExprCommand*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case command_e::Proc: {
    Proc* obj = static_cast<Proc*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case command_e::Func: {
    Func* obj = static_cast<Func*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case command_e::Retval: {
    command__Retval* obj = static_cast<command__Retval*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}
BigStr* b_command_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case b_command_e::VarDecl:
    v = "VarDecl"; break;
  case b_command_e::Mutation:
    v = "Mutation"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "b_command.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

hnode_t* b_command_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case b_command_e::VarDecl: {
    VarDecl* obj = static_cast<VarDecl*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case b_command_e::Mutation: {
    Mutation* obj = static_cast<Mutation*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}
BigStr* glob_part_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case glob_part_e::Literal:
    v = "Literal"; break;
  case glob_part_e::Operator:
    v = "Operator"; break;
  case glob_part_e::CharClass:
    v = "CharClass"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "glob_part.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

hnode_t* glob_part__Literal::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(glob_part_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = Alloc<hnode::Leaf>(Id_str(this->id, false), color_e::UserType);
  L->append(Alloc<Field>(StrFromC("id"), x0));

  hnode_t* x1 = ToPretty(this->s);
  L->append(Alloc<Field>(StrFromC("s"), x1));

  return out_node;
}


hnode_t* glob_part__Operator::PrettyTree(bool do_abbrev, Dict<int, bool>* seen)
                                         {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(glob_part_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = Alloc<hnode::Leaf>(Id_str(this->op_id, false),
                                   color_e::UserType);
  L->append(Alloc<Field>(StrFromC("op_id"), x0));

  return out_node;
}


hnode_t* glob_part__CharClass::PrettyTree(bool do_abbrev, Dict<int, bool>*
                                          seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(glob_part_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = ToPretty(this->negated);
  L->append(Alloc<Field>(StrFromC("negated"), x0));

  if (this->strs != nullptr) {  // List
    hnode::Array* x1 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<BigStr*> it(this->strs); !it.Done(); it.Next()) {
      BigStr* v_ = it.Value();
      hnode_t* h = ToPretty(v_);
      x1->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("strs"), x1));
  }

  return out_node;
}


hnode_t* glob_part_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case glob_part_e::Literal: {
    glob_part__Literal* obj = static_cast<glob_part__Literal*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case glob_part_e::Operator: {
    glob_part__Operator* obj = static_cast<glob_part__Operator*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case glob_part_e::CharClass: {
    glob_part__CharClass* obj = static_cast<glob_part__CharClass*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}
BigStr* printf_part_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case printf_part_e::Literal:
    v = "Literal"; break;
  case printf_part_e::Percent:
    v = "Percent"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "printf_part.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

hnode_t* printf_part__Percent::PrettyTree(bool do_abbrev, Dict<int, bool>*
                                          seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(printf_part_str(this->tag()));
  List<Field*>* L = out_node->fields;

  if (this->flags != nullptr) {  // List
    hnode::Array* x0 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<Token*> it(this->flags); !it.Done(); it.Next()) {
      Token* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x0->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("flags"), x0));
  }

  if (this->width) {  // Optional
    hnode_t* x1 = this->width->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("width"), x1));
  }

  if (this->precision) {  // Optional
    hnode_t* x2 = this->precision->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("precision"), x2));
  }

  hnode_t* x3 = this->type->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("type"), x3));

  return out_node;
}


hnode_t* printf_part_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case printf_part_e::Literal: {
    Token* obj = static_cast<Token*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case printf_part_e::Percent: {
    printf_part__Percent* obj = static_cast<printf_part__Percent*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}
BigStr* expr_context_str(expr_context_e tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case expr_context_e::Load:
    v = "Load"; break;
  case expr_context_e::Store:
    v = "Store"; break;
  case expr_context_e::Del:
    v = "Del"; break;
  case expr_context_e::AugLoad:
    v = "AugLoad"; break;
  case expr_context_e::AugStore:
    v = "AugStore"; break;
  case expr_context_e::Param:
    v = "Param"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "expr_context.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

hnode_t* TypeExpr::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("TypeExpr"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->tok->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("tok"), x0));

  hnode_t* x1 = ToPretty(this->name);
  L->append(Alloc<Field>(StrFromC("name"), x1));

  if (this->params != nullptr) {  // List
    hnode::Array* x2 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<TypeExpr*> it(this->params); !it.Done(); it.Next()) {
      TypeExpr* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x2->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("params"), x2));
  }

  return out_node;
}


hnode_t* NameType::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("NameType"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  hnode_t* x1 = ToPretty(this->name);
  L->append(Alloc<Field>(StrFromC("name"), x1));

  if (this->typ) {  // Optional
    hnode_t* x2 = this->typ->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("typ"), x2));
  }

  return out_node;
}


hnode_t* Comprehension::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("Comprehension"));
  List<Field*>* L = out_node->fields;

  if (this->lhs != nullptr) {  // List
    hnode::Array* x0 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<NameType*> it(this->lhs); !it.Done(); it.Next()) {
      NameType* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x0->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("lhs"), x0));
  }

  hnode_t* x1 = this->iter->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("iter"), x1));

  if (this->cond) {  // Optional
    hnode_t* x2 = this->cond->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("cond"), x2));
  }

  return out_node;
}


hnode_t* NamedArg::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("NamedArg"));
  List<Field*>* L = out_node->fields;

  if (this->name) {  // Optional
    hnode_t* x0 = this->name->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("name"), x0));
  }

  hnode_t* x1 = this->value->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("value"), x1));

  return out_node;
}


hnode_t* Subscript::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("Subscript"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  hnode_t* x1 = this->obj->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("obj"), x1));

  hnode_t* x2 = this->index->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("index"), x2));

  return out_node;
}


hnode_t* Attribute::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("Attribute"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->obj->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("obj"), x0));

  hnode_t* x1 = this->op->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("op"), x1));

  hnode_t* x2 = this->attr->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("attr"), x2));

  hnode_t* x3 = ToPretty(this->attr_name);
  L->append(Alloc<Field>(StrFromC("attr_name"), x3));

  hnode_t* x4 = Alloc<hnode::Leaf>(expr_context_str(this->ctx),
                                   color_e::TypeName);
  L->append(Alloc<Field>(StrFromC("ctx"), x4));

  return out_node;
}

BigStr* y_lhs_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case y_lhs_e::Var:
    v = "Var"; break;
  case y_lhs_e::Subscript:
    v = "Subscript"; break;
  case y_lhs_e::Attribute:
    v = "Attribute"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "y_lhs.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

hnode_t* y_lhs_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case y_lhs_e::Var: {
    Token* obj = static_cast<Token*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case y_lhs_e::Subscript: {
    Subscript* obj = static_cast<Subscript*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case y_lhs_e::Attribute: {
    Attribute* obj = static_cast<Attribute*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}
BigStr* place_op_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case place_op_e::Subscript:
    v = "Subscript"; break;
  case place_op_e::Attribute:
    v = "Attribute"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "place_op.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

hnode_t* place_op__Subscript::PrettyTree(bool do_abbrev, Dict<int, bool>* seen)
                                         {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(place_op_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->op->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("op"), x0));

  hnode_t* x1 = this->index->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("index"), x1));

  return out_node;
}


hnode_t* place_op__Attribute::PrettyTree(bool do_abbrev, Dict<int, bool>* seen)
                                         {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(place_op_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->op->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("op"), x0));

  hnode_t* x1 = this->attr->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("attr"), x1));

  return out_node;
}


hnode_t* place_op_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case place_op_e::Subscript: {
    place_op__Subscript* obj = static_cast<place_op__Subscript*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case place_op_e::Attribute: {
    place_op__Attribute* obj = static_cast<place_op__Attribute*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}
BigStr* expr_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case expr_e::Var:
    v = "Var"; break;
  case expr_e::Const:
    v = "Const"; break;
  case expr_e::Place:
    v = "Place"; break;
  case expr_e::YshArrayLiteral:
    v = "YshArrayLiteral"; break;
  case expr_e::Eggex:
    v = "Eggex"; break;
  case expr_e::SimpleVarSub:
    v = "SimpleVarSub"; break;
  case expr_e::BracedVarSub:
    v = "BracedVarSub"; break;
  case expr_e::CommandSub:
    v = "CommandSub"; break;
  case expr_e::ExprSub:
    v = "ExprSub"; break;
  case expr_e::SingleQuoted:
    v = "SingleQuoted"; break;
  case expr_e::DoubleQuoted:
    v = "DoubleQuoted"; break;
  case expr_e::Literal:
    v = "Literal"; break;
  case expr_e::Lambda:
    v = "Lambda"; break;
  case expr_e::Unary:
    v = "Unary"; break;
  case expr_e::Binary:
    v = "Binary"; break;
  case expr_e::Compare:
    v = "Compare"; break;
  case expr_e::FuncCall:
    v = "FuncCall"; break;
  case expr_e::IfExp:
    v = "IfExp"; break;
  case expr_e::Tuple:
    v = "Tuple"; break;
  case expr_e::List:
    v = "List"; break;
  case expr_e::Dict:
    v = "Dict"; break;
  case expr_e::Implicit:
    v = "Implicit"; break;
  case expr_e::ListComp:
    v = "ListComp"; break;
  case expr_e::DictComp:
    v = "DictComp"; break;
  case expr_e::GeneratorExp:
    v = "GeneratorExp"; break;
  case expr_e::Range:
    v = "Range"; break;
  case expr_e::Slice:
    v = "Slice"; break;
  case expr_e::Subscript:
    v = "Subscript"; break;
  case expr_e::Attribute:
    v = "Attribute"; break;
  case expr_e::Spread:
    v = "Spread"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "expr.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

expr__Implicit* expr::Implicit = &gexpr__Implicit.obj;

GcGlobal<expr__Implicit> gexpr__Implicit = 
  { ObjHeader::Global(expr_e::Implicit) };

hnode_t* expr__Var::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  if (do_abbrev) {
    auto* p = syntax_abbrev::_expr__Var(this);
    if (p) {
      return p;
    }
  }
  hnode::Record* out_node = runtime::NewRecord(expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  hnode_t* x1 = ToPretty(this->name);
  L->append(Alloc<Field>(StrFromC("name"), x1));

  return out_node;
}


hnode_t* expr__Const::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  if (do_abbrev) {
    auto* p = syntax_abbrev::_expr__Const(this);
    if (p) {
      return p;
    }
  }
  hnode::Record* out_node = runtime::NewRecord(expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->c->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("c"), x0));

  hnode_t* x1 = this->val->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("val"), x1));

  return out_node;
}


hnode_t* expr__Place::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->blame_tok->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("blame_tok"), x0));

  hnode_t* x1 = ToPretty(this->var_name);
  L->append(Alloc<Field>(StrFromC("var_name"), x1));

  if (this->ops != nullptr) {  // List
    hnode::Array* x2 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<place_op_t*> it(this->ops); !it.Done(); it.Next()) {
      place_op_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x2->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("ops"), x2));
  }

  return out_node;
}


hnode_t* expr__Literal::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->inner->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("inner"), x0));

  return out_node;
}


hnode_t* expr__Lambda::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  if (this->params != nullptr) {  // List
    hnode::Array* x0 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<NameType*> it(this->params); !it.Done(); it.Next()) {
      NameType* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x0->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("params"), x0));
  }

  hnode_t* x1 = this->body->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("body"), x1));

  return out_node;
}


hnode_t* expr__Unary::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->op->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("op"), x0));

  hnode_t* x1 = this->child->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("child"), x1));

  return out_node;
}


hnode_t* expr__Binary::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->op->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("op"), x0));

  hnode_t* x1 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x1));

  hnode_t* x2 = this->right->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("right"), x2));

  return out_node;
}


hnode_t* expr__Compare::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  if (this->ops != nullptr) {  // List
    hnode::Array* x1 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<Token*> it(this->ops); !it.Done(); it.Next()) {
      Token* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x1->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("ops"), x1));
  }

  if (this->comparators != nullptr) {  // List
    hnode::Array* x2 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<expr_t*> it(this->comparators); !it.Done(); it.Next()) {
      expr_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x2->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("comparators"), x2));
  }

  return out_node;
}


hnode_t* expr__FuncCall::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->func->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("func"), x0));

  hnode_t* x1 = this->args->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("args"), x1));

  return out_node;
}


hnode_t* expr__IfExp::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->test->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("test"), x0));

  hnode_t* x1 = this->body->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("body"), x1));

  hnode_t* x2 = this->orelse->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("orelse"), x2));

  return out_node;
}


hnode_t* expr__Tuple::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  if (this->elts != nullptr) {  // List
    hnode::Array* x1 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<expr_t*> it(this->elts); !it.Done(); it.Next()) {
      expr_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x1->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("elts"), x1));
  }

  hnode_t* x2 = Alloc<hnode::Leaf>(expr_context_str(this->ctx),
                                   color_e::TypeName);
  L->append(Alloc<Field>(StrFromC("ctx"), x2));

  return out_node;
}


hnode_t* expr__List::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  if (this->elts != nullptr) {  // List
    hnode::Array* x1 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<expr_t*> it(this->elts); !it.Done(); it.Next()) {
      expr_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x1->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("elts"), x1));
  }

  hnode_t* x2 = Alloc<hnode::Leaf>(expr_context_str(this->ctx),
                                   color_e::TypeName);
  L->append(Alloc<Field>(StrFromC("ctx"), x2));

  return out_node;
}


hnode_t* expr__Dict::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  if (this->keys != nullptr) {  // List
    hnode::Array* x1 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<expr_t*> it(this->keys); !it.Done(); it.Next()) {
      expr_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x1->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("keys"), x1));
  }

  if (this->values != nullptr) {  // List
    hnode::Array* x2 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<expr_t*> it(this->values); !it.Done(); it.Next()) {
      expr_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x2->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("values"), x2));
  }

  return out_node;
}


hnode_t* expr__Implicit::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(expr_str(this->tag()));
  return out_node;
}


hnode_t* expr__ListComp::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  hnode_t* x1 = this->elt->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("elt"), x1));

  if (this->generators != nullptr) {  // List
    hnode::Array* x2 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<Comprehension*> it(this->generators); !it.Done(); it.Next()) {
      Comprehension* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x2->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("generators"), x2));
  }

  return out_node;
}


hnode_t* expr__DictComp::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  hnode_t* x1 = this->key->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("key"), x1));

  hnode_t* x2 = this->value->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("value"), x2));

  if (this->generators != nullptr) {  // List
    hnode::Array* x3 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<Comprehension*> it(this->generators); !it.Done(); it.Next()) {
      Comprehension* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x3->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("generators"), x3));
  }

  return out_node;
}


hnode_t* expr__GeneratorExp::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->elt->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("elt"), x0));

  if (this->generators != nullptr) {  // List
    hnode::Array* x1 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<Comprehension*> it(this->generators); !it.Done(); it.Next()) {
      Comprehension* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x1->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("generators"), x1));
  }

  return out_node;
}


hnode_t* expr__Range::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->lower->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("lower"), x0));

  hnode_t* x1 = this->op->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("op"), x1));

  hnode_t* x2 = this->upper->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("upper"), x2));

  return out_node;
}


hnode_t* expr__Slice::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  if (this->lower) {  // Optional
    hnode_t* x0 = this->lower->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("lower"), x0));
  }

  hnode_t* x1 = this->op->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("op"), x1));

  if (this->upper) {  // Optional
    hnode_t* x2 = this->upper->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("upper"), x2));
  }

  return out_node;
}


hnode_t* expr__Spread::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(expr_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("left"), x0));

  hnode_t* x1 = this->child->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("child"), x1));

  return out_node;
}


hnode_t* expr_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case expr_e::Var: {
    expr__Var* obj = static_cast<expr__Var*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case expr_e::Const: {
    expr__Const* obj = static_cast<expr__Const*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case expr_e::Place: {
    expr__Place* obj = static_cast<expr__Place*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case expr_e::YshArrayLiteral: {
    YshArrayLiteral* obj = static_cast<YshArrayLiteral*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case expr_e::Eggex: {
    Eggex* obj = static_cast<Eggex*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case expr_e::SimpleVarSub: {
    SimpleVarSub* obj = static_cast<SimpleVarSub*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case expr_e::BracedVarSub: {
    BracedVarSub* obj = static_cast<BracedVarSub*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case expr_e::CommandSub: {
    CommandSub* obj = static_cast<CommandSub*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case expr_e::ExprSub: {
    ExprSub* obj = static_cast<ExprSub*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case expr_e::SingleQuoted: {
    SingleQuoted* obj = static_cast<SingleQuoted*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case expr_e::DoubleQuoted: {
    DoubleQuoted* obj = static_cast<DoubleQuoted*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case expr_e::Literal: {
    expr__Literal* obj = static_cast<expr__Literal*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case expr_e::Lambda: {
    expr__Lambda* obj = static_cast<expr__Lambda*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case expr_e::Unary: {
    expr__Unary* obj = static_cast<expr__Unary*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case expr_e::Binary: {
    expr__Binary* obj = static_cast<expr__Binary*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case expr_e::Compare: {
    expr__Compare* obj = static_cast<expr__Compare*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case expr_e::FuncCall: {
    expr__FuncCall* obj = static_cast<expr__FuncCall*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case expr_e::IfExp: {
    expr__IfExp* obj = static_cast<expr__IfExp*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case expr_e::Tuple: {
    expr__Tuple* obj = static_cast<expr__Tuple*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case expr_e::List: {
    expr__List* obj = static_cast<expr__List*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case expr_e::Dict: {
    expr__Dict* obj = static_cast<expr__Dict*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case expr_e::Implicit: {
    expr__Implicit* obj = static_cast<expr__Implicit*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case expr_e::ListComp: {
    expr__ListComp* obj = static_cast<expr__ListComp*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case expr_e::DictComp: {
    expr__DictComp* obj = static_cast<expr__DictComp*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case expr_e::GeneratorExp: {
    expr__GeneratorExp* obj = static_cast<expr__GeneratorExp*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case expr_e::Range: {
    expr__Range* obj = static_cast<expr__Range*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case expr_e::Slice: {
    expr__Slice* obj = static_cast<expr__Slice*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case expr_e::Subscript: {
    Subscript* obj = static_cast<Subscript*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case expr_e::Attribute: {
    Attribute* obj = static_cast<Attribute*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case expr_e::Spread: {
    expr__Spread* obj = static_cast<expr__Spread*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}

hnode_t* PosixClass::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("PosixClass"));
  List<Field*>* L = out_node->fields;

  if (this->negated) {  // Optional
    hnode_t* x0 = this->negated->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("negated"), x0));
  }

  hnode_t* x1 = ToPretty(this->name);
  L->append(Alloc<Field>(StrFromC("name"), x1));

  return out_node;
}


hnode_t* PerlClass::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("PerlClass"));
  List<Field*>* L = out_node->fields;

  if (this->negated) {  // Optional
    hnode_t* x0 = this->negated->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("negated"), x0));
  }

  hnode_t* x1 = ToPretty(this->name);
  L->append(Alloc<Field>(StrFromC("name"), x1));

  return out_node;
}


hnode_t* CharCode::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("CharCode"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->blame_tok->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("blame_tok"), x0));

  hnode_t* x1 = ToPretty(this->i);
  L->append(Alloc<Field>(StrFromC("i"), x1));

  hnode_t* x2 = ToPretty(this->u_braced);
  L->append(Alloc<Field>(StrFromC("u_braced"), x2));

  return out_node;
}


hnode_t* CharRange::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("CharRange"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->start->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("start"), x0));

  hnode_t* x1 = this->end->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("end"), x1));

  return out_node;
}

BigStr* class_literal_term_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case class_literal_term_e::PosixClass:
    v = "PosixClass"; break;
  case class_literal_term_e::PerlClass:
    v = "PerlClass"; break;
  case class_literal_term_e::CharRange:
    v = "CharRange"; break;
  case class_literal_term_e::CharCode:
    v = "CharCode"; break;
  case class_literal_term_e::SingleQuoted:
    v = "SingleQuoted"; break;
  case class_literal_term_e::Splice:
    v = "Splice"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "class_literal_term.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

hnode_t* class_literal_term__Splice::PrettyTree(bool do_abbrev, Dict<int,
                                                bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node =
runtime::NewRecord(class_literal_term_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->name->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("name"), x0));

  hnode_t* x1 = ToPretty(this->var_name);
  L->append(Alloc<Field>(StrFromC("var_name"), x1));

  return out_node;
}


hnode_t* class_literal_term_t::PrettyTree(bool do_abbrev, Dict<int, bool>*
                                          seen) {
  switch (this->tag()) {
  case class_literal_term_e::PosixClass: {
    PosixClass* obj = static_cast<PosixClass*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case class_literal_term_e::PerlClass: {
    PerlClass* obj = static_cast<PerlClass*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case class_literal_term_e::CharRange: {
    CharRange* obj = static_cast<CharRange*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case class_literal_term_e::CharCode: {
    CharCode* obj = static_cast<CharCode*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case class_literal_term_e::SingleQuoted: {
    SingleQuoted* obj = static_cast<SingleQuoted*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case class_literal_term_e::Splice: {
    class_literal_term__Splice* obj =
static_cast<class_literal_term__Splice*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}
BigStr* char_class_term_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case char_class_term_e::PosixClass:
    v = "PosixClass"; break;
  case char_class_term_e::PerlClass:
    v = "PerlClass"; break;
  case char_class_term_e::CharRange:
    v = "CharRange"; break;
  case char_class_term_e::CharCode:
    v = "CharCode"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "char_class_term.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

hnode_t* char_class_term_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case char_class_term_e::PosixClass: {
    PosixClass* obj = static_cast<PosixClass*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case char_class_term_e::PerlClass: {
    PerlClass* obj = static_cast<PerlClass*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case char_class_term_e::CharRange: {
    CharRange* obj = static_cast<CharRange*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case char_class_term_e::CharCode: {
    CharCode* obj = static_cast<CharCode*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}
BigStr* re_repeat_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case re_repeat_e::Op:
    v = "Op"; break;
  case re_repeat_e::Range:
    v = "Range"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "re_repeat.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

hnode_t* re_repeat__Range::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(re_repeat_str(this->tag()));
  List<Field*>* L = out_node->fields;

  if (this->left) {  // Optional
    hnode_t* x0 = this->left->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("left"), x0));
  }

  hnode_t* x1 = ToPretty(this->lower);
  L->append(Alloc<Field>(StrFromC("lower"), x1));

  hnode_t* x2 = ToPretty(this->upper);
  L->append(Alloc<Field>(StrFromC("upper"), x2));

  if (this->right) {  // Optional
    hnode_t* x3 = this->right->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("right"), x3));
  }

  return out_node;
}


hnode_t* re_repeat_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case re_repeat_e::Op: {
    Token* obj = static_cast<Token*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case re_repeat_e::Range: {
    re_repeat__Range* obj = static_cast<re_repeat__Range*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}
BigStr* re_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case re_e::Primitive:
    v = "Primitive"; break;
  case re_e::PosixClass:
    v = "PosixClass"; break;
  case re_e::PerlClass:
    v = "PerlClass"; break;
  case re_e::CharClassLiteral:
    v = "CharClassLiteral"; break;
  case re_e::CharClass:
    v = "CharClass"; break;
  case re_e::Splice:
    v = "Splice"; break;
  case re_e::SingleQuoted:
    v = "SingleQuoted"; break;
  case re_e::Repeat:
    v = "Repeat"; break;
  case re_e::Seq:
    v = "Seq"; break;
  case re_e::Alt:
    v = "Alt"; break;
  case re_e::Group:
    v = "Group"; break;
  case re_e::Capture:
    v = "Capture"; break;
  case re_e::Backtracking:
    v = "Backtracking"; break;
  case re_e::LiteralChars:
    v = "LiteralChars"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "re.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

hnode_t* re__Primitive::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(re_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->blame_tok->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("blame_tok"), x0));

  hnode_t* x1 = Alloc<hnode::Leaf>(Id_str(this->id, false), color_e::UserType);
  L->append(Alloc<Field>(StrFromC("id"), x1));

  return out_node;
}


hnode_t* re__CharClassLiteral::PrettyTree(bool do_abbrev, Dict<int, bool>*
                                          seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(re_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = ToPretty(this->negated);
  L->append(Alloc<Field>(StrFromC("negated"), x0));

  if (this->terms != nullptr) {  // List
    hnode::Array* x1 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<class_literal_term_t*> it(this->terms); !it.Done();
         it.Next()) {
      class_literal_term_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x1->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("terms"), x1));
  }

  return out_node;
}


hnode_t* re__CharClass::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(re_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = ToPretty(this->negated);
  L->append(Alloc<Field>(StrFromC("negated"), x0));

  if (this->terms != nullptr) {  // List
    hnode::Array* x1 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<char_class_term_t*> it(this->terms); !it.Done(); it.Next()) {
      char_class_term_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x1->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("terms"), x1));
  }

  return out_node;
}


hnode_t* re__Splice::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(re_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->name->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("name"), x0));

  hnode_t* x1 = ToPretty(this->var_name);
  L->append(Alloc<Field>(StrFromC("var_name"), x1));

  return out_node;
}


hnode_t* re__Repeat::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(re_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->child->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("child"), x0));

  hnode_t* x1 = this->op->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("op"), x1));

  return out_node;
}


hnode_t* re__Seq::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(re_str(this->tag()));
  List<Field*>* L = out_node->fields;

  if (this->children != nullptr) {  // List
    hnode::Array* x0 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<re_t*> it(this->children); !it.Done(); it.Next()) {
      re_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x0->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("children"), x0));
  }

  return out_node;
}


hnode_t* re__Alt::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(re_str(this->tag()));
  List<Field*>* L = out_node->fields;

  if (this->children != nullptr) {  // List
    hnode::Array* x0 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<re_t*> it(this->children); !it.Done(); it.Next()) {
      re_t* v_ = it.Value();
      hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
      x0->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("children"), x0));
  }

  return out_node;
}


hnode_t* re__Group::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(re_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->child->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("child"), x0));

  return out_node;
}


hnode_t* re__Capture::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(re_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->child->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("child"), x0));

  if (this->name) {  // Optional
    hnode_t* x1 = this->name->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("name"), x1));
  }

  if (this->func_name) {  // Optional
    hnode_t* x2 = this->func_name->PrettyTree(do_abbrev, seen);
    L->append(Alloc<Field>(StrFromC("func_name"), x2));
  }

  return out_node;
}


hnode_t* re__Backtracking::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(re_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = ToPretty(this->negated);
  L->append(Alloc<Field>(StrFromC("negated"), x0));

  hnode_t* x1 = this->name->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("name"), x1));

  hnode_t* x2 = this->child->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("child"), x2));

  return out_node;
}


hnode_t* re__LiteralChars::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(re_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->blame_tok->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("blame_tok"), x0));

  hnode_t* x1 = ToPretty(this->s);
  L->append(Alloc<Field>(StrFromC("s"), x1));

  return out_node;
}


hnode_t* re_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case re_e::Primitive: {
    re__Primitive* obj = static_cast<re__Primitive*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case re_e::PosixClass: {
    PosixClass* obj = static_cast<PosixClass*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case re_e::PerlClass: {
    PerlClass* obj = static_cast<PerlClass*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case re_e::CharClassLiteral: {
    re__CharClassLiteral* obj = static_cast<re__CharClassLiteral*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case re_e::CharClass: {
    re__CharClass* obj = static_cast<re__CharClass*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case re_e::Splice: {
    re__Splice* obj = static_cast<re__Splice*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case re_e::SingleQuoted: {
    SingleQuoted* obj = static_cast<SingleQuoted*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case re_e::Repeat: {
    re__Repeat* obj = static_cast<re__Repeat*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case re_e::Seq: {
    re__Seq* obj = static_cast<re__Seq*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case re_e::Alt: {
    re__Alt* obj = static_cast<re__Alt*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case re_e::Group: {
    re__Group* obj = static_cast<re__Group*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case re_e::Capture: {
    re__Capture* obj = static_cast<re__Capture*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case re_e::Backtracking: {
    re__Backtracking* obj = static_cast<re__Backtracking*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case re_e::LiteralChars: {
    re__LiteralChars* obj = static_cast<re__LiteralChars*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}

}  // namespace syntax_asdl
