from asdl import pybase

Id_t = int  # type alias for integer

class Id(object):
  Word_Compound = 1
  Arith_Semi = 2
  Arith_Comma = 3
  Arith_Plus = 4
  Arith_Minus = 5
  Arith_Star = 6
  Arith_Slash = 7
  Arith_Percent = 8
  Arith_DPlus = 9
  Arith_DMinus = 10
  Arith_DStar = 11
  Arith_LParen = 12
  Arith_RParen = 13
  Arith_LBracket = 14
  Arith_RBracket = 15
  Arith_RBrace = 16
  Arith_QMark = 17
  Arith_Colon = 18
  Arith_LessEqual = 19
  Arith_Less = 20
  Arith_GreatEqual = 21
  Arith_Great = 22
  Arith_DEqual = 23
  Arith_NEqual = 24
  Arith_DAmp = 25
  Arith_DPipe = 26
  Arith_Bang = 27
  Arith_DGreat = 28
  Arith_DLess = 29
  Arith_Amp = 30
  Arith_Pipe = 31
  Arith_Caret = 32
  Arith_Tilde = 33
  Arith_Equal = 34
  Arith_PlusEqual = 35
  Arith_MinusEqual = 36
  Arith_StarEqual = 37
  Arith_SlashEqual = 38
  Arith_PercentEqual = 39
  Arith_DGreatEqual = 40
  Arith_DLessEqual = 41
  Arith_AmpEqual = 42
  Arith_CaretEqual = 43
  Arith_PipeEqual = 44
  Eof_Real = 45
  Eof_RParen = 46
  Eof_Backtick = 47
  Undefined_Tok = 48
  Unknown_Tok = 49
  Unknown_Backslash = 50
  Unknown_DEqual = 51
  Unknown_DAmp = 52
  Unknown_DPipe = 53
  Unknown_DDot = 54
  Eol_Tok = 55
  Ignored_LineCont = 56
  Ignored_Space = 57
  Ignored_Comment = 58
  Ignored_Newline = 59
  WS_Space = 60
  Lit_Chars = 61
  Lit_CharsWithoutPrefix = 62
  Lit_VarLike = 63
  Lit_ArrayLhsOpen = 64
  Lit_ArrayLhsClose = 65
  Lit_Splice = 66
  Lit_AtLBracket = 67
  Lit_AtLBraceDot = 68
  Lit_Other = 69
  Lit_EscapedChar = 70
  Lit_BackslashDoubleQuote = 71
  Lit_LBracket = 72
  Lit_RBracket = 73
  Lit_Star = 74
  Lit_QMark = 75
  Lit_LBrace = 76
  Lit_RBrace = 77
  Lit_Comma = 78
  Lit_Equals = 79
  Lit_Dollar = 80
  Lit_DRightBracket = 81
  Lit_Tilde = 82
  Lit_Pound = 83
  Lit_TPound = 84
  Lit_TDot = 85
  Lit_Slash = 86
  Lit_Percent = 87
  Lit_Colon = 88
  Lit_Digits = 89
  Lit_At = 90
  Lit_ArithVarLike = 91
  Lit_BadBackslash = 92
  Lit_CompDummy = 93
  Lit_Number = 94
  Lit_RedirVarName = 95
  Lit_HistoryOp_PrevEntry = 96
  Lit_HistoryOp_WordRest = 97
  Lit_HistoryOp_First = 98
  Lit_HistoryOp_Last = 99
  Lit_HistoryNum = 100
  Lit_HistorySearch = 101
  Backtick_Right = 102
  Backtick_Quoted = 103
  Backtick_DoubleQuote = 104
  Backtick_Other = 105
  History_Op = 106
  History_Num = 107
  History_Search = 108
  History_Other = 109
  Op_Newline = 110
  Op_Amp = 111
  Op_Pipe = 112
  Op_PipeAmp = 113
  Op_DAmp = 114
  Op_DPipe = 115
  Op_Semi = 116
  Op_DSemi = 117
  Op_SemiAmp = 118
  Op_DSemiAmp = 119
  Op_LParen = 120
  Op_RParen = 121
  Op_DLeftParen = 122
  Op_DRightParen = 123
  Op_Less = 124
  Op_Great = 125
  Op_Bang = 126
  Op_LBracket = 127
  Op_RBracket = 128
  Op_LBrace = 129
  Op_RBrace = 130
  Expr_Reserved = 131
  Expr_Symbol = 132
  Expr_Name = 133
  Expr_DecInt = 134
  Expr_BinInt = 135
  Expr_OctInt = 136
  Expr_HexInt = 137
  Expr_Float = 138
  Expr_Bang = 139
  Expr_Dot = 140
  Expr_DDotLessThan = 141
  Expr_DDotEqual = 142
  Expr_Colon = 143
  Expr_RArrow = 144
  Expr_RDArrow = 145
  Expr_DSlash = 146
  Expr_TEqual = 147
  Expr_NotDEqual = 148
  Expr_TildeDEqual = 149
  Expr_At = 150
  Expr_DoubleAt = 151
  Expr_Ellipsis = 152
  Expr_Dollar = 153
  Expr_NotTilde = 154
  Expr_DTilde = 155
  Expr_NotDTilde = 156
  Expr_DStarEqual = 157
  Expr_DSlashEqual = 158
  Expr_CastedDummy = 159
  Expr_Null = 160
  Expr_True = 161
  Expr_False = 162
  Expr_And = 163
  Expr_Or = 164
  Expr_Not = 165
  Expr_For = 166
  Expr_Is = 167
  Expr_In = 168
  Expr_If = 169
  Expr_Else = 170
  Expr_Capture = 171
  Expr_As = 172
  Expr_Func = 173
  Expr_Proc = 174
  Char_OneChar = 175
  Char_Stop = 176
  Char_Hex = 177
  Char_YHex = 178
  Char_Octal3 = 179
  Char_Octal4 = 180
  Char_Unicode4 = 181
  Char_SurrogatePair = 182
  Char_Unicode8 = 183
  Char_UBraced = 184
  Char_Pound = 185
  Char_AsciiControl = 186
  BashRegex_LParen = 187
  BashRegex_AllowedInParens = 188
  Eggex_Start = 189
  Eggex_End = 190
  Eggex_Dot = 191
  Redir_Less = 192
  Redir_Great = 193
  Redir_DLess = 194
  Redir_TLess = 195
  Redir_DGreat = 196
  Redir_GreatAnd = 197
  Redir_LessAnd = 198
  Redir_DLessDash = 199
  Redir_LessGreat = 200
  Redir_Clobber = 201
  Redir_AndGreat = 202
  Redir_AndDGreat = 203
  Left_DoubleQuote = 204
  Left_JDoubleQuote = 205
  Left_SingleQuote = 206
  Left_DollarSingleQuote = 207
  Left_RSingleQuote = 208
  Left_USingleQuote = 209
  Left_BSingleQuote = 210
  Left_TDoubleQuote = 211
  Left_DollarTDoubleQuote = 212
  Left_TSingleQuote = 213
  Left_RTSingleQuote = 214
  Left_UTSingleQuote = 215
  Left_BTSingleQuote = 216
  Left_Backtick = 217
  Left_DollarParen = 218
  Left_DollarBrace = 219
  Left_DollarBraceZsh = 220
  Left_DollarDParen = 221
  Left_DollarBracket = 222
  Left_AtBracket = 223
  Left_DollarDoubleQuote = 224
  Left_ProcSubIn = 225
  Left_ProcSubOut = 226
  Left_AtParen = 227
  Left_CaretParen = 228
  Left_CaretBracket = 229
  Left_CaretBrace = 230
  Left_CaretDoubleQuote = 231
  Left_ColonPipe = 232
  Left_PercentParen = 233
  Right_DoubleQuote = 234
  Right_SingleQuote = 235
  Right_Backtick = 236
  Right_DollarBrace = 237
  Right_DollarDParen = 238
  Right_DollarDoubleQuote = 239
  Right_DollarSingleQuote = 240
  Right_Subshell = 241
  Right_ShFunction = 242
  Right_CasePat = 243
  Right_Initializer = 244
  Right_ExtGlob = 245
  Right_BashRegexGroup = 246
  Right_BlockLiteral = 247
  ExtGlob_Comma = 248
  ExtGlob_At = 249
  ExtGlob_Star = 250
  ExtGlob_Plus = 251
  ExtGlob_QMark = 252
  ExtGlob_Bang = 253
  VSub_DollarName = 254
  VSub_Name = 255
  VSub_Number = 256
  VSub_Bang = 257
  VSub_At = 258
  VSub_Pound = 259
  VSub_Dollar = 260
  VSub_Star = 261
  VSub_Hyphen = 262
  VSub_QMark = 263
  VSub_Dot = 264
  VTest_ColonHyphen = 265
  VTest_Hyphen = 266
  VTest_ColonEquals = 267
  VTest_Equals = 268
  VTest_ColonQMark = 269
  VTest_QMark = 270
  VTest_ColonPlus = 271
  VTest_Plus = 272
  VOp0_Q = 273
  VOp0_E = 274
  VOp0_P = 275
  VOp0_A = 276
  VOp0_a = 277
  VOp1_Percent = 278
  VOp1_DPercent = 279
  VOp1_Pound = 280
  VOp1_DPound = 281
  VOp1_Caret = 282
  VOp1_DCaret = 283
  VOp1_Comma = 284
  VOp1_DComma = 285
  VOpYsh_Pipe = 286
  VOpYsh_Space = 287
  VOp2_Slash = 288
  VOp2_Colon = 289
  VOp2_LBracket = 290
  VOp2_RBracket = 291
  VOp3_At = 292
  VOp3_Star = 293
  Node_PostDPlus = 294
  Node_PostDMinus = 295
  Node_UnaryPlus = 296
  Node_UnaryMinus = 297
  Node_NotIn = 298
  Node_IsNot = 299
  KW_DLeftBracket = 300
  KW_Bang = 301
  KW_For = 302
  KW_While = 303
  KW_Until = 304
  KW_Do = 305
  KW_Done = 306
  KW_In = 307
  KW_Case = 308
  KW_Esac = 309
  KW_If = 310
  KW_Fi = 311
  KW_Then = 312
  KW_Else = 313
  KW_Elif = 314
  KW_Function = 315
  KW_Time = 316
  KW_Const = 317
  KW_Var = 318
  KW_SetVar = 319
  KW_SetGlobal = 320
  KW_Call = 321
  KW_Proc = 322
  KW_Typed = 323
  KW_Func = 324
  ControlFlow_Break = 325
  ControlFlow_Continue = 326
  ControlFlow_Return = 327
  ControlFlow_Exit = 328
  LookAhead_FuncParens = 329
  Glob_LBracket = 330
  Glob_RBracket = 331
  Glob_Star = 332
  Glob_QMark = 333
  Glob_Bang = 334
  Glob_Caret = 335
  Glob_EscapedChar = 336
  Glob_BadBackslash = 337
  Glob_CleanLiterals = 338
  Glob_OtherLiteral = 339
  Format_EscapedPercent = 340
  Format_Percent = 341
  Format_Flag = 342
  Format_Num = 343
  Format_Dot = 344
  Format_Type = 345
  Format_Star = 346
  Format_Time = 347
  Format_Zero = 348
  PS_Subst = 349
  PS_Octal3 = 350
  PS_LBrace = 351
  PS_RBrace = 352
  PS_Literals = 353
  PS_BadBackslash = 354
  Range_Int = 355
  Range_Char = 356
  Range_Dots = 357
  Range_Other = 358
  J8_LBracket = 359
  J8_RBracket = 360
  J8_LBrace = 361
  J8_RBrace = 362
  J8_Comma = 363
  J8_Colon = 364
  J8_Null = 365
  J8_Bool = 366
  J8_Int = 367
  J8_Float = 368
  J8_String = 369
  J8_Identifier = 370
  J8_Newline = 371
  J8_Tab = 372
  J8_LParen = 373
  J8_RParen = 374
  J8_Operator = 375
  ShNumber_Dec = 376
  ShNumber_Hex = 377
  ShNumber_Oct = 378
  ShNumber_BaseN = 379
  BoolUnary_z = 380
  BoolUnary_n = 381
  BoolUnary_o = 382
  BoolUnary_t = 383
  BoolUnary_v = 384
  BoolUnary_R = 385
  BoolUnary_a = 386
  BoolUnary_b = 387
  BoolUnary_c = 388
  BoolUnary_d = 389
  BoolUnary_e = 390
  BoolUnary_f = 391
  BoolUnary_g = 392
  BoolUnary_h = 393
  BoolUnary_k = 394
  BoolUnary_L = 395
  BoolUnary_p = 396
  BoolUnary_r = 397
  BoolUnary_s = 398
  BoolUnary_S = 399
  BoolUnary_u = 400
  BoolUnary_w = 401
  BoolUnary_x = 402
  BoolUnary_O = 403
  BoolUnary_G = 404
  BoolUnary_N = 405
  BoolUnary_true = 406
  BoolUnary_false = 407
  BoolBinary_GlobEqual = 408
  BoolBinary_GlobDEqual = 409
  BoolBinary_GlobNEqual = 410
  BoolBinary_EqualTilde = 411
  BoolBinary_ef = 412
  BoolBinary_nt = 413
  BoolBinary_ot = 414
  BoolBinary_eq = 415
  BoolBinary_ne = 416
  BoolBinary_gt = 417
  BoolBinary_ge = 418
  BoolBinary_lt = 419
  BoolBinary_le = 420
  BoolBinary_Equal = 421
  BoolBinary_DEqual = 422
  BoolBinary_NEqual = 423
  ARRAY_SIZE = 424

_Id_str = {
  1: 'Word_Compound',
  2: 'Arith_Semi',
  3: 'Arith_Comma',
  4: 'Arith_Plus',
  5: 'Arith_Minus',
  6: 'Arith_Star',
  7: 'Arith_Slash',
  8: 'Arith_Percent',
  9: 'Arith_DPlus',
  10: 'Arith_DMinus',
  11: 'Arith_DStar',
  12: 'Arith_LParen',
  13: 'Arith_RParen',
  14: 'Arith_LBracket',
  15: 'Arith_RBracket',
  16: 'Arith_RBrace',
  17: 'Arith_QMark',
  18: 'Arith_Colon',
  19: 'Arith_LessEqual',
  20: 'Arith_Less',
  21: 'Arith_GreatEqual',
  22: 'Arith_Great',
  23: 'Arith_DEqual',
  24: 'Arith_NEqual',
  25: 'Arith_DAmp',
  26: 'Arith_DPipe',
  27: 'Arith_Bang',
  28: 'Arith_DGreat',
  29: 'Arith_DLess',
  30: 'Arith_Amp',
  31: 'Arith_Pipe',
  32: 'Arith_Caret',
  33: 'Arith_Tilde',
  34: 'Arith_Equal',
  35: 'Arith_PlusEqual',
  36: 'Arith_MinusEqual',
  37: 'Arith_StarEqual',
  38: 'Arith_SlashEqual',
  39: 'Arith_PercentEqual',
  40: 'Arith_DGreatEqual',
  41: 'Arith_DLessEqual',
  42: 'Arith_AmpEqual',
  43: 'Arith_CaretEqual',
  44: 'Arith_PipeEqual',
  45: 'Eof_Real',
  46: 'Eof_RParen',
  47: 'Eof_Backtick',
  48: 'Undefined_Tok',
  49: 'Unknown_Tok',
  50: 'Unknown_Backslash',
  51: 'Unknown_DEqual',
  52: 'Unknown_DAmp',
  53: 'Unknown_DPipe',
  54: 'Unknown_DDot',
  55: 'Eol_Tok',
  56: 'Ignored_LineCont',
  57: 'Ignored_Space',
  58: 'Ignored_Comment',
  59: 'Ignored_Newline',
  60: 'WS_Space',
  61: 'Lit_Chars',
  62: 'Lit_CharsWithoutPrefix',
  63: 'Lit_VarLike',
  64: 'Lit_ArrayLhsOpen',
  65: 'Lit_ArrayLhsClose',
  66: 'Lit_Splice',
  67: 'Lit_AtLBracket',
  68: 'Lit_AtLBraceDot',
  69: 'Lit_Other',
  70: 'Lit_EscapedChar',
  71: 'Lit_BackslashDoubleQuote',
  72: 'Lit_LBracket',
  73: 'Lit_RBracket',
  74: 'Lit_Star',
  75: 'Lit_QMark',
  76: 'Lit_LBrace',
  77: 'Lit_RBrace',
  78: 'Lit_Comma',
  79: 'Lit_Equals',
  80: 'Lit_Dollar',
  81: 'Lit_DRightBracket',
  82: 'Lit_Tilde',
  83: 'Lit_Pound',
  84: 'Lit_TPound',
  85: 'Lit_TDot',
  86: 'Lit_Slash',
  87: 'Lit_Percent',
  88: 'Lit_Colon',
  89: 'Lit_Digits',
  90: 'Lit_At',
  91: 'Lit_ArithVarLike',
  92: 'Lit_BadBackslash',
  93: 'Lit_CompDummy',
  94: 'Lit_Number',
  95: 'Lit_RedirVarName',
  96: 'Lit_HistoryOp_PrevEntry',
  97: 'Lit_HistoryOp_WordRest',
  98: 'Lit_HistoryOp_First',
  99: 'Lit_HistoryOp_Last',
  100: 'Lit_HistoryNum',
  101: 'Lit_HistorySearch',
  102: 'Backtick_Right',
  103: 'Backtick_Quoted',
  104: 'Backtick_DoubleQuote',
  105: 'Backtick_Other',
  106: 'History_Op',
  107: 'History_Num',
  108: 'History_Search',
  109: 'History_Other',
  110: 'Op_Newline',
  111: 'Op_Amp',
  112: 'Op_Pipe',
  113: 'Op_PipeAmp',
  114: 'Op_DAmp',
  115: 'Op_DPipe',
  116: 'Op_Semi',
  117: 'Op_DSemi',
  118: 'Op_SemiAmp',
  119: 'Op_DSemiAmp',
  120: 'Op_LParen',
  121: 'Op_RParen',
  122: 'Op_DLeftParen',
  123: 'Op_DRightParen',
  124: 'Op_Less',
  125: 'Op_Great',
  126: 'Op_Bang',
  127: 'Op_LBracket',
  128: 'Op_RBracket',
  129: 'Op_LBrace',
  130: 'Op_RBrace',
  131: 'Expr_Reserved',
  132: 'Expr_Symbol',
  133: 'Expr_Name',
  134: 'Expr_DecInt',
  135: 'Expr_BinInt',
  136: 'Expr_OctInt',
  137: 'Expr_HexInt',
  138: 'Expr_Float',
  139: 'Expr_Bang',
  140: 'Expr_Dot',
  141: 'Expr_DDotLessThan',
  142: 'Expr_DDotEqual',
  143: 'Expr_Colon',
  144: 'Expr_RArrow',
  145: 'Expr_RDArrow',
  146: 'Expr_DSlash',
  147: 'Expr_TEqual',
  148: 'Expr_NotDEqual',
  149: 'Expr_TildeDEqual',
  150: 'Expr_At',
  151: 'Expr_DoubleAt',
  152: 'Expr_Ellipsis',
  153: 'Expr_Dollar',
  154: 'Expr_NotTilde',
  155: 'Expr_DTilde',
  156: 'Expr_NotDTilde',
  157: 'Expr_DStarEqual',
  158: 'Expr_DSlashEqual',
  159: 'Expr_CastedDummy',
  160: 'Expr_Null',
  161: 'Expr_True',
  162: 'Expr_False',
  163: 'Expr_And',
  164: 'Expr_Or',
  165: 'Expr_Not',
  166: 'Expr_For',
  167: 'Expr_Is',
  168: 'Expr_In',
  169: 'Expr_If',
  170: 'Expr_Else',
  171: 'Expr_Capture',
  172: 'Expr_As',
  173: 'Expr_Func',
  174: 'Expr_Proc',
  175: 'Char_OneChar',
  176: 'Char_Stop',
  177: 'Char_Hex',
  178: 'Char_YHex',
  179: 'Char_Octal3',
  180: 'Char_Octal4',
  181: 'Char_Unicode4',
  182: 'Char_SurrogatePair',
  183: 'Char_Unicode8',
  184: 'Char_UBraced',
  185: 'Char_Pound',
  186: 'Char_AsciiControl',
  187: 'BashRegex_LParen',
  188: 'BashRegex_AllowedInParens',
  189: 'Eggex_Start',
  190: 'Eggex_End',
  191: 'Eggex_Dot',
  192: 'Redir_Less',
  193: 'Redir_Great',
  194: 'Redir_DLess',
  195: 'Redir_TLess',
  196: 'Redir_DGreat',
  197: 'Redir_GreatAnd',
  198: 'Redir_LessAnd',
  199: 'Redir_DLessDash',
  200: 'Redir_LessGreat',
  201: 'Redir_Clobber',
  202: 'Redir_AndGreat',
  203: 'Redir_AndDGreat',
  204: 'Left_DoubleQuote',
  205: 'Left_JDoubleQuote',
  206: 'Left_SingleQuote',
  207: 'Left_DollarSingleQuote',
  208: 'Left_RSingleQuote',
  209: 'Left_USingleQuote',
  210: 'Left_BSingleQuote',
  211: 'Left_TDoubleQuote',
  212: 'Left_DollarTDoubleQuote',
  213: 'Left_TSingleQuote',
  214: 'Left_RTSingleQuote',
  215: 'Left_UTSingleQuote',
  216: 'Left_BTSingleQuote',
  217: 'Left_Backtick',
  218: 'Left_DollarParen',
  219: 'Left_DollarBrace',
  220: 'Left_DollarBraceZsh',
  221: 'Left_DollarDParen',
  222: 'Left_DollarBracket',
  223: 'Left_AtBracket',
  224: 'Left_DollarDoubleQuote',
  225: 'Left_ProcSubIn',
  226: 'Left_ProcSubOut',
  227: 'Left_AtParen',
  228: 'Left_CaretParen',
  229: 'Left_CaretBracket',
  230: 'Left_CaretBrace',
  231: 'Left_CaretDoubleQuote',
  232: 'Left_ColonPipe',
  233: 'Left_PercentParen',
  234: 'Right_DoubleQuote',
  235: 'Right_SingleQuote',
  236: 'Right_Backtick',
  237: 'Right_DollarBrace',
  238: 'Right_DollarDParen',
  239: 'Right_DollarDoubleQuote',
  240: 'Right_DollarSingleQuote',
  241: 'Right_Subshell',
  242: 'Right_ShFunction',
  243: 'Right_CasePat',
  244: 'Right_Initializer',
  245: 'Right_ExtGlob',
  246: 'Right_BashRegexGroup',
  247: 'Right_BlockLiteral',
  248: 'ExtGlob_Comma',
  249: 'ExtGlob_At',
  250: 'ExtGlob_Star',
  251: 'ExtGlob_Plus',
  252: 'ExtGlob_QMark',
  253: 'ExtGlob_Bang',
  254: 'VSub_DollarName',
  255: 'VSub_Name',
  256: 'VSub_Number',
  257: 'VSub_Bang',
  258: 'VSub_At',
  259: 'VSub_Pound',
  260: 'VSub_Dollar',
  261: 'VSub_Star',
  262: 'VSub_Hyphen',
  263: 'VSub_QMark',
  264: 'VSub_Dot',
  265: 'VTest_ColonHyphen',
  266: 'VTest_Hyphen',
  267: 'VTest_ColonEquals',
  268: 'VTest_Equals',
  269: 'VTest_ColonQMark',
  270: 'VTest_QMark',
  271: 'VTest_ColonPlus',
  272: 'VTest_Plus',
  273: 'VOp0_Q',
  274: 'VOp0_E',
  275: 'VOp0_P',
  276: 'VOp0_A',
  277: 'VOp0_a',
  278: 'VOp1_Percent',
  279: 'VOp1_DPercent',
  280: 'VOp1_Pound',
  281: 'VOp1_DPound',
  282: 'VOp1_Caret',
  283: 'VOp1_DCaret',
  284: 'VOp1_Comma',
  285: 'VOp1_DComma',
  286: 'VOpYsh_Pipe',
  287: 'VOpYsh_Space',
  288: 'VOp2_Slash',
  289: 'VOp2_Colon',
  290: 'VOp2_LBracket',
  291: 'VOp2_RBracket',
  292: 'VOp3_At',
  293: 'VOp3_Star',
  294: 'Node_PostDPlus',
  295: 'Node_PostDMinus',
  296: 'Node_UnaryPlus',
  297: 'Node_UnaryMinus',
  298: 'Node_NotIn',
  299: 'Node_IsNot',
  300: 'KW_DLeftBracket',
  301: 'KW_Bang',
  302: 'KW_For',
  303: 'KW_While',
  304: 'KW_Until',
  305: 'KW_Do',
  306: 'KW_Done',
  307: 'KW_In',
  308: 'KW_Case',
  309: 'KW_Esac',
  310: 'KW_If',
  311: 'KW_Fi',
  312: 'KW_Then',
  313: 'KW_Else',
  314: 'KW_Elif',
  315: 'KW_Function',
  316: 'KW_Time',
  317: 'KW_Const',
  318: 'KW_Var',
  319: 'KW_SetVar',
  320: 'KW_SetGlobal',
  321: 'KW_Call',
  322: 'KW_Proc',
  323: 'KW_Typed',
  324: 'KW_Func',
  325: 'ControlFlow_Break',
  326: 'ControlFlow_Continue',
  327: 'ControlFlow_Return',
  328: 'ControlFlow_Exit',
  329: 'LookAhead_FuncParens',
  330: 'Glob_LBracket',
  331: 'Glob_RBracket',
  332: 'Glob_Star',
  333: 'Glob_QMark',
  334: 'Glob_Bang',
  335: 'Glob_Caret',
  336: 'Glob_EscapedChar',
  337: 'Glob_BadBackslash',
  338: 'Glob_CleanLiterals',
  339: 'Glob_OtherLiteral',
  340: 'Format_EscapedPercent',
  341: 'Format_Percent',
  342: 'Format_Flag',
  343: 'Format_Num',
  344: 'Format_Dot',
  345: 'Format_Type',
  346: 'Format_Star',
  347: 'Format_Time',
  348: 'Format_Zero',
  349: 'PS_Subst',
  350: 'PS_Octal3',
  351: 'PS_LBrace',
  352: 'PS_RBrace',
  353: 'PS_Literals',
  354: 'PS_BadBackslash',
  355: 'Range_Int',
  356: 'Range_Char',
  357: 'Range_Dots',
  358: 'Range_Other',
  359: 'J8_LBracket',
  360: 'J8_RBracket',
  361: 'J8_LBrace',
  362: 'J8_RBrace',
  363: 'J8_Comma',
  364: 'J8_Colon',
  365: 'J8_Null',
  366: 'J8_Bool',
  367: 'J8_Int',
  368: 'J8_Float',
  369: 'J8_String',
  370: 'J8_Identifier',
  371: 'J8_Newline',
  372: 'J8_Tab',
  373: 'J8_LParen',
  374: 'J8_RParen',
  375: 'J8_Operator',
  376: 'ShNumber_Dec',
  377: 'ShNumber_Hex',
  378: 'ShNumber_Oct',
  379: 'ShNumber_BaseN',
  380: 'BoolUnary_z',
  381: 'BoolUnary_n',
  382: 'BoolUnary_o',
  383: 'BoolUnary_t',
  384: 'BoolUnary_v',
  385: 'BoolUnary_R',
  386: 'BoolUnary_a',
  387: 'BoolUnary_b',
  388: 'BoolUnary_c',
  389: 'BoolUnary_d',
  390: 'BoolUnary_e',
  391: 'BoolUnary_f',
  392: 'BoolUnary_g',
  393: 'BoolUnary_h',
  394: 'BoolUnary_k',
  395: 'BoolUnary_L',
  396: 'BoolUnary_p',
  397: 'BoolUnary_r',
  398: 'BoolUnary_s',
  399: 'BoolUnary_S',
  400: 'BoolUnary_u',
  401: 'BoolUnary_w',
  402: 'BoolUnary_x',
  403: 'BoolUnary_O',
  404: 'BoolUnary_G',
  405: 'BoolUnary_N',
  406: 'BoolUnary_true',
  407: 'BoolUnary_false',
  408: 'BoolBinary_GlobEqual',
  409: 'BoolBinary_GlobDEqual',
  410: 'BoolBinary_GlobNEqual',
  411: 'BoolBinary_EqualTilde',
  412: 'BoolBinary_ef',
  413: 'BoolBinary_nt',
  414: 'BoolBinary_ot',
  415: 'BoolBinary_eq',
  416: 'BoolBinary_ne',
  417: 'BoolBinary_gt',
  418: 'BoolBinary_ge',
  419: 'BoolBinary_lt',
  420: 'BoolBinary_le',
  421: 'BoolBinary_Equal',
  422: 'BoolBinary_DEqual',
  423: 'BoolBinary_NEqual',
}

def Id_str(val, dot=True):
  # type: (Id_t, bool) -> str
  v = _Id_str[val]
  if dot:
    return "Id.%s" % v
  else:
    return v

class Kind_t(pybase.SimpleObj):
  pass

class Kind(object):
  Word = Kind_t(1)
  Arith = Kind_t(2)
  Eof = Kind_t(3)
  Undefined = Kind_t(4)
  Unknown = Kind_t(5)
  Eol = Kind_t(6)
  Ignored = Kind_t(7)
  WS = Kind_t(8)
  Lit = Kind_t(9)
  Backtick = Kind_t(10)
  History = Kind_t(11)
  Op = Kind_t(12)
  Expr = Kind_t(13)
  Char = Kind_t(14)
  BashRegex = Kind_t(15)
  Eggex = Kind_t(16)
  Redir = Kind_t(17)
  Left = Kind_t(18)
  Right = Kind_t(19)
  ExtGlob = Kind_t(20)
  VSub = Kind_t(21)
  VTest = Kind_t(22)
  VOp0 = Kind_t(23)
  VOp1 = Kind_t(24)
  VOpYsh = Kind_t(25)
  VOp2 = Kind_t(26)
  VOp3 = Kind_t(27)
  Node = Kind_t(28)
  KW = Kind_t(29)
  ControlFlow = Kind_t(30)
  LookAhead = Kind_t(31)
  Glob = Kind_t(32)
  Format = Kind_t(33)
  PS = Kind_t(34)
  Range = Kind_t(35)
  J8 = Kind_t(36)
  ShNumber = Kind_t(37)
  BoolUnary = Kind_t(38)
  BoolBinary = Kind_t(39)

_Kind_str = {
  1: 'Word',
  2: 'Arith',
  3: 'Eof',
  4: 'Undefined',
  5: 'Unknown',
  6: 'Eol',
  7: 'Ignored',
  8: 'WS',
  9: 'Lit',
  10: 'Backtick',
  11: 'History',
  12: 'Op',
  13: 'Expr',
  14: 'Char',
  15: 'BashRegex',
  16: 'Eggex',
  17: 'Redir',
  18: 'Left',
  19: 'Right',
  20: 'ExtGlob',
  21: 'VSub',
  22: 'VTest',
  23: 'VOp0',
  24: 'VOp1',
  25: 'VOpYsh',
  26: 'VOp2',
  27: 'VOp3',
  28: 'Node',
  29: 'KW',
  30: 'ControlFlow',
  31: 'LookAhead',
  32: 'Glob',
  33: 'Format',
  34: 'PS',
  35: 'Range',
  36: 'J8',
  37: 'ShNumber',
  38: 'BoolUnary',
  39: 'BoolBinary',
}

def Kind_str(val, dot=True):
  # type: (Kind_t, bool) -> str
  v = _Kind_str[val]
  if dot:
    return "Kind.%s" % v
  else:
    return v

