#ifndef ID_KIND_ASDL_H
#define ID_KIND_ASDL_H

#include <stdint.h>  // uint16_t

class BigStr;

namespace id_kind_asdl {

#define ASDL_NAMES struct
ASDL_NAMES Id {
  enum no_name {
  Word_Compound = 1,
  Arith_Semi = 2,
  Arith_Comma = 3,
  Arith_Plus = 4,
  Arith_Minus = 5,
  Arith_Star = 6,
  Arith_Slash = 7,
  Arith_Percent = 8,
  Arith_DPlus = 9,
  Arith_DMinus = 10,
  Arith_DStar = 11,
  Arith_LParen = 12,
  Arith_RParen = 13,
  Arith_LBracket = 14,
  Arith_RBracket = 15,
  Arith_RBrace = 16,
  Arith_QMark = 17,
  Arith_Colon = 18,
  Arith_LessEqual = 19,
  Arith_Less = 20,
  Arith_GreatEqual = 21,
  Arith_Great = 22,
  Arith_DEqual = 23,
  Arith_NEqual = 24,
  Arith_DAmp = 25,
  Arith_DPipe = 26,
  Arith_Bang = 27,
  Arith_DGreat = 28,
  Arith_DLess = 29,
  Arith_Amp = 30,
  Arith_Pipe = 31,
  Arith_Caret = 32,
  Arith_Tilde = 33,
  Arith_Equal = 34,
  Arith_PlusEqual = 35,
  Arith_MinusEqual = 36,
  Arith_StarEqual = 37,
  Arith_SlashEqual = 38,
  Arith_PercentEqual = 39,
  Arith_DGreatEqual = 40,
  Arith_DLessEqual = 41,
  Arith_AmpEqual = 42,
  Arith_CaretEqual = 43,
  Arith_PipeEqual = 44,
  Eof_Real = 45,
  Eof_RParen = 46,
  Eof_Backtick = 47,
  Undefined_Tok = 48,
  Unknown_Tok = 49,
  Unknown_Backslash = 50,
  Unknown_DEqual = 51,
  Unknown_DAmp = 52,
  Unknown_DPipe = 53,
  Unknown_DDot = 54,
  Eol_Tok = 55,
  Ignored_LineCont = 56,
  Ignored_Space = 57,
  Ignored_Comment = 58,
  Ignored_Newline = 59,
  WS_Space = 60,
  Lit_Chars = 61,
  Lit_CharsWithoutPrefix = 62,
  Lit_VarLike = 63,
  Lit_ArrayLhsOpen = 64,
  Lit_ArrayLhsClose = 65,
  Lit_Splice = 66,
  Lit_AtLBracket = 67,
  Lit_AtLBraceDot = 68,
  Lit_Other = 69,
  Lit_EscapedChar = 70,
  Lit_BackslashDoubleQuote = 71,
  Lit_LBracket = 72,
  Lit_RBracket = 73,
  Lit_Star = 74,
  Lit_QMark = 75,
  Lit_LBrace = 76,
  Lit_RBrace = 77,
  Lit_Comma = 78,
  Lit_Equals = 79,
  Lit_Dollar = 80,
  Lit_DRightBracket = 81,
  Lit_Tilde = 82,
  Lit_Pound = 83,
  Lit_TPound = 84,
  Lit_TDot = 85,
  Lit_Slash = 86,
  Lit_Percent = 87,
  Lit_Colon = 88,
  Lit_Digits = 89,
  Lit_At = 90,
  Lit_ArithVarLike = 91,
  Lit_BadBackslash = 92,
  Lit_CompDummy = 93,
  Lit_Number = 94,
  Lit_RedirVarName = 95,
  Lit_HistoryOp_PrevEntry = 96,
  Lit_HistoryOp_WordRest = 97,
  Lit_HistoryOp_First = 98,
  Lit_HistoryOp_Last = 99,
  Lit_HistoryNum = 100,
  Lit_HistorySearch = 101,
  Backtick_Right = 102,
  Backtick_Quoted = 103,
  Backtick_DoubleQuote = 104,
  Backtick_Other = 105,
  History_Op = 106,
  History_Num = 107,
  History_Search = 108,
  History_Other = 109,
  Op_Newline = 110,
  Op_Amp = 111,
  Op_Pipe = 112,
  Op_PipeAmp = 113,
  Op_DAmp = 114,
  Op_DPipe = 115,
  Op_Semi = 116,
  Op_DSemi = 117,
  Op_SemiAmp = 118,
  Op_DSemiAmp = 119,
  Op_LParen = 120,
  Op_RParen = 121,
  Op_DLeftParen = 122,
  Op_DRightParen = 123,
  Op_Less = 124,
  Op_Great = 125,
  Op_Bang = 126,
  Op_LBracket = 127,
  Op_RBracket = 128,
  Op_LBrace = 129,
  Op_RBrace = 130,
  Expr_Reserved = 131,
  Expr_Symbol = 132,
  Expr_Name = 133,
  Expr_DecInt = 134,
  Expr_BinInt = 135,
  Expr_OctInt = 136,
  Expr_HexInt = 137,
  Expr_Float = 138,
  Expr_Bang = 139,
  Expr_Dot = 140,
  Expr_DDotLessThan = 141,
  Expr_DDotEqual = 142,
  Expr_Colon = 143,
  Expr_RArrow = 144,
  Expr_RDArrow = 145,
  Expr_DSlash = 146,
  Expr_TEqual = 147,
  Expr_NotDEqual = 148,
  Expr_TildeDEqual = 149,
  Expr_At = 150,
  Expr_DoubleAt = 151,
  Expr_Ellipsis = 152,
  Expr_Dollar = 153,
  Expr_NotTilde = 154,
  Expr_DTilde = 155,
  Expr_NotDTilde = 156,
  Expr_DStarEqual = 157,
  Expr_DSlashEqual = 158,
  Expr_CastedDummy = 159,
  Expr_Null = 160,
  Expr_True = 161,
  Expr_False = 162,
  Expr_And = 163,
  Expr_Or = 164,
  Expr_Not = 165,
  Expr_For = 166,
  Expr_Is = 167,
  Expr_In = 168,
  Expr_If = 169,
  Expr_Else = 170,
  Expr_Capture = 171,
  Expr_As = 172,
  Expr_Func = 173,
  Expr_Proc = 174,
  Char_OneChar = 175,
  Char_Stop = 176,
  Char_Hex = 177,
  Char_YHex = 178,
  Char_Octal3 = 179,
  Char_Octal4 = 180,
  Char_Unicode4 = 181,
  Char_SurrogatePair = 182,
  Char_Unicode8 = 183,
  Char_UBraced = 184,
  Char_Pound = 185,
  Char_AsciiControl = 186,
  BashRegex_LParen = 187,
  BashRegex_AllowedInParens = 188,
  Eggex_Start = 189,
  Eggex_End = 190,
  Eggex_Dot = 191,
  Redir_Less = 192,
  Redir_Great = 193,
  Redir_DLess = 194,
  Redir_TLess = 195,
  Redir_DGreat = 196,
  Redir_GreatAnd = 197,
  Redir_LessAnd = 198,
  Redir_DLessDash = 199,
  Redir_LessGreat = 200,
  Redir_Clobber = 201,
  Redir_AndGreat = 202,
  Redir_AndDGreat = 203,
  Left_DoubleQuote = 204,
  Left_JDoubleQuote = 205,
  Left_SingleQuote = 206,
  Left_DollarSingleQuote = 207,
  Left_RSingleQuote = 208,
  Left_USingleQuote = 209,
  Left_BSingleQuote = 210,
  Left_TDoubleQuote = 211,
  Left_DollarTDoubleQuote = 212,
  Left_TSingleQuote = 213,
  Left_RTSingleQuote = 214,
  Left_UTSingleQuote = 215,
  Left_BTSingleQuote = 216,
  Left_Backtick = 217,
  Left_DollarParen = 218,
  Left_DollarBrace = 219,
  Left_DollarBraceZsh = 220,
  Left_DollarDParen = 221,
  Left_DollarBracket = 222,
  Left_AtBracket = 223,
  Left_DollarDoubleQuote = 224,
  Left_ProcSubIn = 225,
  Left_ProcSubOut = 226,
  Left_AtParen = 227,
  Left_CaretParen = 228,
  Left_CaretBracket = 229,
  Left_CaretBrace = 230,
  Left_CaretDoubleQuote = 231,
  Left_ColonPipe = 232,
  Left_PercentParen = 233,
  Right_DoubleQuote = 234,
  Right_SingleQuote = 235,
  Right_Backtick = 236,
  Right_DollarBrace = 237,
  Right_DollarDParen = 238,
  Right_DollarDoubleQuote = 239,
  Right_DollarSingleQuote = 240,
  Right_Subshell = 241,
  Right_ShFunction = 242,
  Right_CasePat = 243,
  Right_Initializer = 244,
  Right_ExtGlob = 245,
  Right_BashRegexGroup = 246,
  Right_BlockLiteral = 247,
  ExtGlob_Comma = 248,
  ExtGlob_At = 249,
  ExtGlob_Star = 250,
  ExtGlob_Plus = 251,
  ExtGlob_QMark = 252,
  ExtGlob_Bang = 253,
  VSub_DollarName = 254,
  VSub_Name = 255,
  VSub_Number = 256,
  VSub_Bang = 257,
  VSub_At = 258,
  VSub_Pound = 259,
  VSub_Dollar = 260,
  VSub_Star = 261,
  VSub_Hyphen = 262,
  VSub_QMark = 263,
  VSub_Dot = 264,
  VTest_ColonHyphen = 265,
  VTest_Hyphen = 266,
  VTest_ColonEquals = 267,
  VTest_Equals = 268,
  VTest_ColonQMark = 269,
  VTest_QMark = 270,
  VTest_ColonPlus = 271,
  VTest_Plus = 272,
  VOp0_Q = 273,
  VOp0_E = 274,
  VOp0_P = 275,
  VOp0_A = 276,
  VOp0_a = 277,
  VOp1_Percent = 278,
  VOp1_DPercent = 279,
  VOp1_Pound = 280,
  VOp1_DPound = 281,
  VOp1_Caret = 282,
  VOp1_DCaret = 283,
  VOp1_Comma = 284,
  VOp1_DComma = 285,
  VOpYsh_Pipe = 286,
  VOpYsh_Space = 287,
  VOp2_Slash = 288,
  VOp2_Colon = 289,
  VOp2_LBracket = 290,
  VOp2_RBracket = 291,
  VOp3_At = 292,
  VOp3_Star = 293,
  Node_PostDPlus = 294,
  Node_PostDMinus = 295,
  Node_UnaryPlus = 296,
  Node_UnaryMinus = 297,
  Node_NotIn = 298,
  Node_IsNot = 299,
  KW_DLeftBracket = 300,
  KW_Bang = 301,
  KW_For = 302,
  KW_While = 303,
  KW_Until = 304,
  KW_Do = 305,
  KW_Done = 306,
  KW_In = 307,
  KW_Case = 308,
  KW_Esac = 309,
  KW_If = 310,
  KW_Fi = 311,
  KW_Then = 312,
  KW_Else = 313,
  KW_Elif = 314,
  KW_Function = 315,
  KW_Time = 316,
  KW_Const = 317,
  KW_Var = 318,
  KW_SetVar = 319,
  KW_SetGlobal = 320,
  KW_Call = 321,
  KW_Proc = 322,
  KW_Typed = 323,
  KW_Func = 324,
  ControlFlow_Break = 325,
  ControlFlow_Continue = 326,
  ControlFlow_Return = 327,
  ControlFlow_Exit = 328,
  LookAhead_FuncParens = 329,
  Glob_LBracket = 330,
  Glob_RBracket = 331,
  Glob_Star = 332,
  Glob_QMark = 333,
  Glob_Bang = 334,
  Glob_Caret = 335,
  Glob_EscapedChar = 336,
  Glob_BadBackslash = 337,
  Glob_CleanLiterals = 338,
  Glob_OtherLiteral = 339,
  Format_EscapedPercent = 340,
  Format_Percent = 341,
  Format_Flag = 342,
  Format_Num = 343,
  Format_Dot = 344,
  Format_Type = 345,
  Format_Star = 346,
  Format_Time = 347,
  Format_Zero = 348,
  PS_Subst = 349,
  PS_Octal3 = 350,
  PS_LBrace = 351,
  PS_RBrace = 352,
  PS_Literals = 353,
  PS_BadBackslash = 354,
  Range_Int = 355,
  Range_Char = 356,
  Range_Dots = 357,
  Range_Other = 358,
  J8_LBracket = 359,
  J8_RBracket = 360,
  J8_LBrace = 361,
  J8_RBrace = 362,
  J8_Comma = 363,
  J8_Colon = 364,
  J8_Null = 365,
  J8_Bool = 366,
  J8_Int = 367,
  J8_Float = 368,
  J8_String = 369,
  J8_Identifier = 370,
  J8_Newline = 371,
  J8_Tab = 372,
  J8_LParen = 373,
  J8_RParen = 374,
  J8_Operator = 375,
  ShNumber_Dec = 376,
  ShNumber_Hex = 377,
  ShNumber_Oct = 378,
  ShNumber_BaseN = 379,
  BoolUnary_z = 380,
  BoolUnary_n = 381,
  BoolUnary_o = 382,
  BoolUnary_t = 383,
  BoolUnary_v = 384,
  BoolUnary_R = 385,
  BoolUnary_a = 386,
  BoolUnary_b = 387,
  BoolUnary_c = 388,
  BoolUnary_d = 389,
  BoolUnary_e = 390,
  BoolUnary_f = 391,
  BoolUnary_g = 392,
  BoolUnary_h = 393,
  BoolUnary_k = 394,
  BoolUnary_L = 395,
  BoolUnary_p = 396,
  BoolUnary_r = 397,
  BoolUnary_s = 398,
  BoolUnary_S = 399,
  BoolUnary_u = 400,
  BoolUnary_w = 401,
  BoolUnary_x = 402,
  BoolUnary_O = 403,
  BoolUnary_G = 404,
  BoolUnary_N = 405,
  BoolUnary_true = 406,
  BoolUnary_false = 407,
  BoolBinary_GlobEqual = 408,
  BoolBinary_GlobDEqual = 409,
  BoolBinary_GlobNEqual = 410,
  BoolBinary_EqualTilde = 411,
  BoolBinary_ef = 412,
  BoolBinary_nt = 413,
  BoolBinary_ot = 414,
  BoolBinary_eq = 415,
  BoolBinary_ne = 416,
  BoolBinary_gt = 417,
  BoolBinary_ge = 418,
  BoolBinary_lt = 419,
  BoolBinary_le = 420,
  BoolBinary_Equal = 421,
  BoolBinary_DEqual = 422,
  BoolBinary_NEqual = 423,
  ARRAY_SIZE = 424,
  };
};

BigStr* Id_str(int tag, bool dot = true);

typedef uint16_t Id_t;

enum class Kind {
  Word = 1,
  Arith = 2,
  Eof = 3,
  Undefined = 4,
  Unknown = 5,
  Eol = 6,
  Ignored = 7,
  WS = 8,
  Lit = 9,
  Backtick = 10,
  History = 11,
  Op = 12,
  Expr = 13,
  Char = 14,
  BashRegex = 15,
  Eggex = 16,
  Redir = 17,
  Left = 18,
  Right = 19,
  ExtGlob = 20,
  VSub = 21,
  VTest = 22,
  VOp0 = 23,
  VOp1 = 24,
  VOpYsh = 25,
  VOp2 = 26,
  VOp3 = 27,
  Node = 28,
  KW = 29,
  ControlFlow = 30,
  LookAhead = 31,
  Glob = 32,
  Format = 33,
  PS = 34,
  Range = 35,
  J8 = 36,
  ShNumber = 37,
  BoolUnary = 38,
  BoolBinary = 39,
};
typedef Kind Kind_t;

BigStr* Kind_str(Kind tag, bool dot = true);


}  // namespace id_kind_asdl

#endif  // ID_KIND_ASDL_H
