#ifndef ID_KIND_ASDL_H
#define ID_KIND_ASDL_H

#include <stdint.h>  // uint16_t

class BigStr;

namespace id_kind_asdl {

#define ASDL_NAMES struct
ASDL_NAMES Id {
  enum no_name {
  Word_Compound = 1,
  Arith_Semi = 2,
  Arith_Comma = 3,
  Arith_Plus = 4,
  Arith_Minus = 5,
  Arith_Star = 6,
  Arith_Slash = 7,
  Arith_Percent = 8,
  Arith_DPlus = 9,
  Arith_DMinus = 10,
  Arith_DStar = 11,
  Arith_LParen = 12,
  Arith_RParen = 13,
  Arith_LBracket = 14,
  Arith_RBracket = 15,
  Arith_RBrace = 16,
  Arith_QMark = 17,
  Arith_Colon = 18,
  Arith_LessEqual = 19,
  Arith_Less = 20,
  Arith_GreatEqual = 21,
  Arith_Great = 22,
  Arith_DEqual = 23,
  Arith_NEqual = 24,
  Arith_DAmp = 25,
  Arith_DPipe = 26,
  Arith_Bang = 27,
  Arith_DGreat = 28,
  Arith_DLess = 29,
  Arith_Amp = 30,
  Arith_Pipe = 31,
  Arith_Caret = 32,
  Arith_Tilde = 33,
  Arith_Equal = 34,
  Arith_PlusEqual = 35,
  Arith_MinusEqual = 36,
  Arith_StarEqual = 37,
  Arith_SlashEqual = 38,
  Arith_PercentEqual = 39,
  Arith_DGreatEqual = 40,
  Arith_DLessEqual = 41,
  Arith_AmpEqual = 42,
  Arith_CaretEqual = 43,
  Arith_PipeEqual = 44,
  Eof_Real = 45,
  Eof_RParen = 46,
  Eof_Backtick = 47,
  Undefined_Tok = 48,
  Unknown_Tok = 49,
  Unknown_Backslash = 50,
  Unknown_DEqual = 51,
  Unknown_DAmp = 52,
  Unknown_DPipe = 53,
  Unknown_DDot = 54,
  Eol_Tok = 55,
  Ignored_LineCont = 56,
  Ignored_Space = 57,
  Ignored_Comment = 58,
  Ignored_Newline = 59,
  WS_Space = 60,
  Lit_Chars = 61,
  Lit_CharsWithoutPrefix = 62,
  Lit_VarLike = 63,
  Lit_ArrayLhsOpen = 64,
  Lit_ArrayLhsClose = 65,
  Lit_Splice = 66,
  Lit_AtLBracket = 67,
  Lit_AtLBraceDot = 68,
  Lit_Other = 69,
  Lit_EscapedChar = 70,
  Lit_EscapedDoubleQuote = 71,
  Lit_LBracket = 72,
  Lit_RBracket = 73,
  Lit_Star = 74,
  Lit_QMark = 75,
  Lit_LBrace = 76,
  Lit_RBrace = 77,
  Lit_Comma = 78,
  Lit_Equals = 79,
  Lit_Dollar = 80,
  Lit_DRightBracket = 81,
  Lit_Tilde = 82,
  Lit_Pound = 83,
  Lit_TPound = 84,
  Lit_TDot = 85,
  Lit_Slash = 86,
  Lit_Percent = 87,
  Lit_Colon = 88,
  Lit_Digits = 89,
  Lit_At = 90,
  Lit_ArithVarLike = 91,
  Lit_BadBackslash = 92,
  Lit_CompDummy = 93,
  Lit_Number = 94,
  Lit_RedirVarName = 95,
  Backtick_Right = 96,
  Backtick_Quoted = 97,
  Backtick_DoubleQuote = 98,
  Backtick_Other = 99,
  History_Op = 100,
  History_Num = 101,
  History_Search = 102,
  History_Other = 103,
  Op_Newline = 104,
  Op_Amp = 105,
  Op_Pipe = 106,
  Op_PipeAmp = 107,
  Op_DAmp = 108,
  Op_DPipe = 109,
  Op_Semi = 110,
  Op_DSemi = 111,
  Op_SemiAmp = 112,
  Op_DSemiAmp = 113,
  Op_LParen = 114,
  Op_RParen = 115,
  Op_DLeftParen = 116,
  Op_DRightParen = 117,
  Op_Less = 118,
  Op_Great = 119,
  Op_Bang = 120,
  Op_LBracket = 121,
  Op_RBracket = 122,
  Op_LBrace = 123,
  Op_RBrace = 124,
  Expr_Reserved = 125,
  Expr_Symbol = 126,
  Expr_Name = 127,
  Expr_DecInt = 128,
  Expr_BinInt = 129,
  Expr_OctInt = 130,
  Expr_HexInt = 131,
  Expr_Float = 132,
  Expr_Bang = 133,
  Expr_Dot = 134,
  Expr_DDotLessThan = 135,
  Expr_DDotEqual = 136,
  Expr_Colon = 137,
  Expr_RArrow = 138,
  Expr_RDArrow = 139,
  Expr_DSlash = 140,
  Expr_TEqual = 141,
  Expr_NotDEqual = 142,
  Expr_TildeDEqual = 143,
  Expr_At = 144,
  Expr_DoubleAt = 145,
  Expr_Ellipsis = 146,
  Expr_Dollar = 147,
  Expr_NotTilde = 148,
  Expr_DTilde = 149,
  Expr_NotDTilde = 150,
  Expr_DStarEqual = 151,
  Expr_DSlashEqual = 152,
  Expr_CastedDummy = 153,
  Expr_Null = 154,
  Expr_True = 155,
  Expr_False = 156,
  Expr_And = 157,
  Expr_Or = 158,
  Expr_Not = 159,
  Expr_For = 160,
  Expr_Is = 161,
  Expr_In = 162,
  Expr_If = 163,
  Expr_Else = 164,
  Expr_Capture = 165,
  Expr_As = 166,
  Expr_Func = 167,
  Expr_Proc = 168,
  Char_OneChar = 169,
  Char_Stop = 170,
  Char_Hex = 171,
  Char_YHex = 172,
  Char_Octal3 = 173,
  Char_Octal4 = 174,
  Char_Unicode4 = 175,
  Char_SurrogatePair = 176,
  Char_Unicode8 = 177,
  Char_UBraced = 178,
  Char_Pound = 179,
  Char_AsciiControl = 180,
  BashRegex_LParen = 181,
  BashRegex_AllowedInParens = 182,
  Eggex_Start = 183,
  Eggex_End = 184,
  Eggex_Dot = 185,
  Redir_Less = 186,
  Redir_Great = 187,
  Redir_DLess = 188,
  Redir_TLess = 189,
  Redir_DGreat = 190,
  Redir_GreatAnd = 191,
  Redir_LessAnd = 192,
  Redir_DLessDash = 193,
  Redir_LessGreat = 194,
  Redir_Clobber = 195,
  Redir_AndGreat = 196,
  Redir_AndDGreat = 197,
  Left_DoubleQuote = 198,
  Left_JDoubleQuote = 199,
  Left_SingleQuote = 200,
  Left_DollarSingleQuote = 201,
  Left_RSingleQuote = 202,
  Left_USingleQuote = 203,
  Left_BSingleQuote = 204,
  Left_TDoubleQuote = 205,
  Left_DollarTDoubleQuote = 206,
  Left_TSingleQuote = 207,
  Left_RTSingleQuote = 208,
  Left_UTSingleQuote = 209,
  Left_BTSingleQuote = 210,
  Left_Backtick = 211,
  Left_DollarParen = 212,
  Left_DollarBrace = 213,
  Left_DollarBraceZsh = 214,
  Left_DollarDParen = 215,
  Left_DollarBracket = 216,
  Left_AtBracket = 217,
  Left_DollarDoubleQuote = 218,
  Left_ProcSubIn = 219,
  Left_ProcSubOut = 220,
  Left_AtParen = 221,
  Left_CaretParen = 222,
  Left_CaretBracket = 223,
  Left_CaretBrace = 224,
  Left_CaretDoubleQuote = 225,
  Left_ColonPipe = 226,
  Left_PercentParen = 227,
  Right_DoubleQuote = 228,
  Right_SingleQuote = 229,
  Right_Backtick = 230,
  Right_DollarBrace = 231,
  Right_DollarDParen = 232,
  Right_DollarDoubleQuote = 233,
  Right_DollarSingleQuote = 234,
  Right_Subshell = 235,
  Right_ShFunction = 236,
  Right_CasePat = 237,
  Right_Initializer = 238,
  Right_ExtGlob = 239,
  Right_BashRegexGroup = 240,
  Right_BlockLiteral = 241,
  ExtGlob_Comma = 242,
  ExtGlob_At = 243,
  ExtGlob_Star = 244,
  ExtGlob_Plus = 245,
  ExtGlob_QMark = 246,
  ExtGlob_Bang = 247,
  VSub_DollarName = 248,
  VSub_Name = 249,
  VSub_Number = 250,
  VSub_Bang = 251,
  VSub_At = 252,
  VSub_Pound = 253,
  VSub_Dollar = 254,
  VSub_Star = 255,
  VSub_Hyphen = 256,
  VSub_QMark = 257,
  VSub_Dot = 258,
  VTest_ColonHyphen = 259,
  VTest_Hyphen = 260,
  VTest_ColonEquals = 261,
  VTest_Equals = 262,
  VTest_ColonQMark = 263,
  VTest_QMark = 264,
  VTest_ColonPlus = 265,
  VTest_Plus = 266,
  VOp0_Q = 267,
  VOp0_E = 268,
  VOp0_P = 269,
  VOp0_A = 270,
  VOp0_a = 271,
  VOp1_Percent = 272,
  VOp1_DPercent = 273,
  VOp1_Pound = 274,
  VOp1_DPound = 275,
  VOp1_Caret = 276,
  VOp1_DCaret = 277,
  VOp1_Comma = 278,
  VOp1_DComma = 279,
  VOpYsh_Pipe = 280,
  VOpYsh_Space = 281,
  VOp2_Slash = 282,
  VOp2_Colon = 283,
  VOp2_LBracket = 284,
  VOp2_RBracket = 285,
  VOp3_At = 286,
  VOp3_Star = 287,
  Node_PostDPlus = 288,
  Node_PostDMinus = 289,
  Node_UnaryPlus = 290,
  Node_UnaryMinus = 291,
  Node_NotIn = 292,
  Node_IsNot = 293,
  KW_DLeftBracket = 294,
  KW_Bang = 295,
  KW_For = 296,
  KW_While = 297,
  KW_Until = 298,
  KW_Do = 299,
  KW_Done = 300,
  KW_In = 301,
  KW_Case = 302,
  KW_Esac = 303,
  KW_If = 304,
  KW_Fi = 305,
  KW_Then = 306,
  KW_Else = 307,
  KW_Elif = 308,
  KW_Function = 309,
  KW_Time = 310,
  KW_Const = 311,
  KW_Var = 312,
  KW_SetVar = 313,
  KW_SetGlobal = 314,
  KW_Call = 315,
  KW_Proc = 316,
  KW_Typed = 317,
  KW_Func = 318,
  ControlFlow_Break = 319,
  ControlFlow_Continue = 320,
  ControlFlow_Return = 321,
  ControlFlow_Exit = 322,
  LookAhead_FuncParens = 323,
  Glob_LBracket = 324,
  Glob_RBracket = 325,
  Glob_Star = 326,
  Glob_QMark = 327,
  Glob_Bang = 328,
  Glob_Caret = 329,
  Glob_EscapedChar = 330,
  Glob_BadBackslash = 331,
  Glob_CleanLiterals = 332,
  Glob_OtherLiteral = 333,
  Format_EscapedPercent = 334,
  Format_Percent = 335,
  Format_Flag = 336,
  Format_Num = 337,
  Format_Dot = 338,
  Format_Type = 339,
  Format_Star = 340,
  Format_Time = 341,
  Format_Zero = 342,
  PS_Subst = 343,
  PS_Octal3 = 344,
  PS_LBrace = 345,
  PS_RBrace = 346,
  PS_Literals = 347,
  PS_BadBackslash = 348,
  Range_Int = 349,
  Range_Char = 350,
  Range_Dots = 351,
  Range_Other = 352,
  J8_LBracket = 353,
  J8_RBracket = 354,
  J8_LBrace = 355,
  J8_RBrace = 356,
  J8_Comma = 357,
  J8_Colon = 358,
  J8_Null = 359,
  J8_Bool = 360,
  J8_Int = 361,
  J8_Float = 362,
  J8_String = 363,
  J8_Identifier = 364,
  J8_Newline = 365,
  J8_Tab = 366,
  J8_LParen = 367,
  J8_RParen = 368,
  J8_Operator = 369,
  ShNumber_Dec = 370,
  ShNumber_Hex = 371,
  ShNumber_Oct = 372,
  ShNumber_BaseN = 373,
  BoolUnary_z = 374,
  BoolUnary_n = 375,
  BoolUnary_o = 376,
  BoolUnary_t = 377,
  BoolUnary_v = 378,
  BoolUnary_R = 379,
  BoolUnary_a = 380,
  BoolUnary_b = 381,
  BoolUnary_c = 382,
  BoolUnary_d = 383,
  BoolUnary_e = 384,
  BoolUnary_f = 385,
  BoolUnary_g = 386,
  BoolUnary_h = 387,
  BoolUnary_k = 388,
  BoolUnary_L = 389,
  BoolUnary_p = 390,
  BoolUnary_r = 391,
  BoolUnary_s = 392,
  BoolUnary_S = 393,
  BoolUnary_u = 394,
  BoolUnary_w = 395,
  BoolUnary_x = 396,
  BoolUnary_O = 397,
  BoolUnary_G = 398,
  BoolUnary_N = 399,
  BoolUnary_true = 400,
  BoolUnary_false = 401,
  BoolBinary_GlobEqual = 402,
  BoolBinary_GlobDEqual = 403,
  BoolBinary_GlobNEqual = 404,
  BoolBinary_EqualTilde = 405,
  BoolBinary_ef = 406,
  BoolBinary_nt = 407,
  BoolBinary_ot = 408,
  BoolBinary_eq = 409,
  BoolBinary_ne = 410,
  BoolBinary_gt = 411,
  BoolBinary_ge = 412,
  BoolBinary_lt = 413,
  BoolBinary_le = 414,
  BoolBinary_Equal = 415,
  BoolBinary_DEqual = 416,
  BoolBinary_NEqual = 417,
  ARRAY_SIZE = 418,
  };
};

BigStr* Id_str(int tag, bool dot = true);

typedef uint16_t Id_t;

enum class Kind {
  Word = 1,
  Arith = 2,
  Eof = 3,
  Undefined = 4,
  Unknown = 5,
  Eol = 6,
  Ignored = 7,
  WS = 8,
  Lit = 9,
  Backtick = 10,
  History = 11,
  Op = 12,
  Expr = 13,
  Char = 14,
  BashRegex = 15,
  Eggex = 16,
  Redir = 17,
  Left = 18,
  Right = 19,
  ExtGlob = 20,
  VSub = 21,
  VTest = 22,
  VOp0 = 23,
  VOp1 = 24,
  VOpYsh = 25,
  VOp2 = 26,
  VOp3 = 27,
  Node = 28,
  KW = 29,
  ControlFlow = 30,
  LookAhead = 31,
  Glob = 32,
  Format = 33,
  PS = 34,
  Range = 35,
  J8 = 36,
  ShNumber = 37,
  BoolUnary = 38,
  BoolBinary = 39,
};
typedef Kind Kind_t;

BigStr* Kind_str(Kind tag, bool dot = true);


}  // namespace id_kind_asdl

#endif  // ID_KIND_ASDL_H
