from asdl import pybase

option_t = int  # type alias for integer

class option_i(object):
  errexit = 1
  nounset = 2
  pipefail = 3
  inherit_errexit = 4
  nullglob = 5
  verbose_errexit = 6
  verbose_warn = 7
  allexport = 8
  noexec = 9
  xtrace = 10
  verbose = 11
  noglob = 12
  noclobber = 13
  errtrace = 14
  posix = 15
  vi = 16
  emacs = 17
  interactive = 18
  hashall = 19
  lastpipe = 20
  failglob = 21
  extglob = 22
  nocasematch = 23
  dotglob = 24
  extdebug = 25
  eval_unsafe_arith = 26
  ignore_flags_not_impl = 27
  ignore_shopt_not_impl = 28
  rewrite_extern = 29
  _allow_command_sub = 30
  _allow_process_sub = 31
  dynamic_scope = 32
  redefine_const = 33
  redefine_source = 34
  _running_trap = 35
  _running_hay = 36
  _no_debug_trap = 37
  _no_err_trap = 38
  strict_parse_equals = 39
  strict_parse_slice = 40
  strict_argv = 41
  strict_arith = 42
  strict_arg_parse = 43
  strict_array = 44
  strict_control_flow = 45
  strict_env_binding = 46
  strict_errexit = 47
  strict_nameref = 48
  strict_word_eval = 49
  strict_tilde = 50
  strict_glob = 51
  parse_at = 52
  parse_proc = 53
  parse_func = 54
  parse_brace = 55
  parse_bracket = 56
  parse_equals = 57
  parse_paren = 58
  parse_ysh_string = 59
  parse_triple_quote = 60
  parse_subexpr_shorthand = 61
  simple_word_eval = 62
  no_dash_glob = 63
  command_sub_errexit = 64
  process_sub_fail = 65
  xtrace_rich = 66
  no_xtrace_osh = 67
  sigpipe_status_ok = 68
  env_obj = 69
  init_ysh_globals = 70
  for_loop_frames = 71
  parse_at_all = 72
  no_parse_backslash = 73
  no_parse_backticks = 74
  no_parse_bare_word = 75
  no_parse_dbracket = 76
  no_parse_dollar = 77
  no_parse_dparen = 78
  no_parse_ignored = 79
  no_parse_osh = 80
  no_parse_sh_arith = 81
  no_parse_word_join = 82
  no_exported = 83
  no_init_globals = 84
  no_osh_builtins = 85
  simple_echo = 86
  simple_eval_builtin = 87
  simple_test_builtin = 88
  simple_trap_builtin = 89
  expand_aliases = 90
  progcomp = 91
  hostcomplete = 92
  histappend = 93
  cmdhist = 94
  assoc_expand_once = 95
  autocd = 96
  cdable_vars = 97
  cdspell = 98
  checkhash = 99
  checkjobs = 100
  checkwinsize = 101
  complete_fullquote = 102
  direxpand = 103
  dirspell = 104
  execfail = 105
  extquote = 106
  force_fignore = 107
  globasciiranges = 108
  globstar = 109
  gnu_errfmt = 110
  histreedit = 111
  histverify = 112
  huponexit = 113
  interactive_comments = 114
  lithist = 115
  localvar_inherit = 116
  localvar_unset = 117
  login_shell = 118
  mailwarn = 119
  no_empty_cmd_completion = 120
  nocaseglob = 121
  progcomp_alias = 122
  promptvars = 123
  restricted_shell = 124
  shift_verbose = 125
  sourcepath = 126
  xpg_echo = 127
  ARRAY_SIZE = 128

_option_str = {
  1: 'errexit',
  2: 'nounset',
  3: 'pipefail',
  4: 'inherit_errexit',
  5: 'nullglob',
  6: 'verbose_errexit',
  7: 'verbose_warn',
  8: 'allexport',
  9: 'noexec',
  10: 'xtrace',
  11: 'verbose',
  12: 'noglob',
  13: 'noclobber',
  14: 'errtrace',
  15: 'posix',
  16: 'vi',
  17: 'emacs',
  18: 'interactive',
  19: 'hashall',
  20: 'lastpipe',
  21: 'failglob',
  22: 'extglob',
  23: 'nocasematch',
  24: 'dotglob',
  25: 'extdebug',
  26: 'eval_unsafe_arith',
  27: 'ignore_flags_not_impl',
  28: 'ignore_shopt_not_impl',
  29: 'rewrite_extern',
  30: '_allow_command_sub',
  31: '_allow_process_sub',
  32: 'dynamic_scope',
  33: 'redefine_const',
  34: 'redefine_source',
  35: '_running_trap',
  36: '_running_hay',
  37: '_no_debug_trap',
  38: '_no_err_trap',
  39: 'strict_parse_equals',
  40: 'strict_parse_slice',
  41: 'strict_argv',
  42: 'strict_arith',
  43: 'strict_arg_parse',
  44: 'strict_array',
  45: 'strict_control_flow',
  46: 'strict_env_binding',
  47: 'strict_errexit',
  48: 'strict_nameref',
  49: 'strict_word_eval',
  50: 'strict_tilde',
  51: 'strict_glob',
  52: 'parse_at',
  53: 'parse_proc',
  54: 'parse_func',
  55: 'parse_brace',
  56: 'parse_bracket',
  57: 'parse_equals',
  58: 'parse_paren',
  59: 'parse_ysh_string',
  60: 'parse_triple_quote',
  61: 'parse_subexpr_shorthand',
  62: 'simple_word_eval',
  63: 'no_dash_glob',
  64: 'command_sub_errexit',
  65: 'process_sub_fail',
  66: 'xtrace_rich',
  67: 'no_xtrace_osh',
  68: 'sigpipe_status_ok',
  69: 'env_obj',
  70: 'init_ysh_globals',
  71: 'for_loop_frames',
  72: 'parse_at_all',
  73: 'no_parse_backslash',
  74: 'no_parse_backticks',
  75: 'no_parse_bare_word',
  76: 'no_parse_dbracket',
  77: 'no_parse_dollar',
  78: 'no_parse_dparen',
  79: 'no_parse_ignored',
  80: 'no_parse_osh',
  81: 'no_parse_sh_arith',
  82: 'no_parse_word_join',
  83: 'no_exported',
  84: 'no_init_globals',
  85: 'no_osh_builtins',
  86: 'simple_echo',
  87: 'simple_eval_builtin',
  88: 'simple_test_builtin',
  89: 'simple_trap_builtin',
  90: 'expand_aliases',
  91: 'progcomp',
  92: 'hostcomplete',
  93: 'histappend',
  94: 'cmdhist',
  95: 'assoc_expand_once',
  96: 'autocd',
  97: 'cdable_vars',
  98: 'cdspell',
  99: 'checkhash',
  100: 'checkjobs',
  101: 'checkwinsize',
  102: 'complete_fullquote',
  103: 'direxpand',
  104: 'dirspell',
  105: 'execfail',
  106: 'extquote',
  107: 'force_fignore',
  108: 'globasciiranges',
  109: 'globstar',
  110: 'gnu_errfmt',
  111: 'histreedit',
  112: 'histverify',
  113: 'huponexit',
  114: 'interactive_comments',
  115: 'lithist',
  116: 'localvar_inherit',
  117: 'localvar_unset',
  118: 'login_shell',
  119: 'mailwarn',
  120: 'no_empty_cmd_completion',
  121: 'nocaseglob',
  122: 'progcomp_alias',
  123: 'promptvars',
  124: 'restricted_shell',
  125: 'shift_verbose',
  126: 'sourcepath',
  127: 'xpg_echo',
}

def option_str(val, dot=True):
  # type: (option_t, bool) -> str
  v = _option_str[val]
  if dot:
    return "option.%s" % v
  else:
    return v

builtin_t = int  # type alias for integer

class builtin_i(object):
  colon = 1
  dot = 2
  exec_ = 3
  eval = 4
  set = 5
  shift = 6
  times = 7
  trap = 8
  unset = 9
  readonly = 10
  local = 11
  declare = 12
  typeset = 13
  export_ = 14
  true_ = 15
  false_ = 16
  try_ = 17
  assert_ = 18
  break_ = 19
  continue_ = 20
  return_ = 21
  exit = 22
  read = 23
  echo = 24
  printf = 25
  mapfile = 26
  readarray = 27
  cd = 28
  chdir = 29
  pushd = 30
  popd = 31
  dirs = 32
  pwd = 33
  source = 34
  umask = 35
  ulimit = 36
  wait = 37
  jobs = 38
  fg = 39
  bg = 40
  kill = 41
  shopt = 42
  complete = 43
  compgen = 44
  compopt = 45
  compadjust = 46
  compexport = 47
  getopts = 48
  builtin = 49
  command = 50
  type = 51
  hash = 52
  help = 53
  history = 54
  fc = 55
  alias = 56
  unalias = 57
  bind = 58
  append = 59
  write = 60
  json = 61
  json8 = 62
  pp = 63
  hay = 64
  haynode = 65
  use = 66
  error = 67
  failed = 68
  fork = 69
  forkwait = 70
  redir = 71
  fopen = 72
  shvar = 73
  ctx = 74
  invoke = 75
  runproc = 76
  boolstatus = 77
  test = 78
  bracket = 79
  push_registers = 80
  source_guard = 81
  is_main = 82
  cat = 83
  rm = 84
  sleep = 85
  ARRAY_SIZE = 86

_builtin_str = {
  1: 'colon',
  2: 'dot',
  3: 'exec_',
  4: 'eval',
  5: 'set',
  6: 'shift',
  7: 'times',
  8: 'trap',
  9: 'unset',
  10: 'readonly',
  11: 'local',
  12: 'declare',
  13: 'typeset',
  14: 'export_',
  15: 'true_',
  16: 'false_',
  17: 'try_',
  18: 'assert_',
  19: 'break_',
  20: 'continue_',
  21: 'return_',
  22: 'exit',
  23: 'read',
  24: 'echo',
  25: 'printf',
  26: 'mapfile',
  27: 'readarray',
  28: 'cd',
  29: 'chdir',
  30: 'pushd',
  31: 'popd',
  32: 'dirs',
  33: 'pwd',
  34: 'source',
  35: 'umask',
  36: 'ulimit',
  37: 'wait',
  38: 'jobs',
  39: 'fg',
  40: 'bg',
  41: 'kill',
  42: 'shopt',
  43: 'complete',
  44: 'compgen',
  45: 'compopt',
  46: 'compadjust',
  47: 'compexport',
  48: 'getopts',
  49: 'builtin',
  50: 'command',
  51: 'type',
  52: 'hash',
  53: 'help',
  54: 'history',
  55: 'fc',
  56: 'alias',
  57: 'unalias',
  58: 'bind',
  59: 'append',
  60: 'write',
  61: 'json',
  62: 'json8',
  63: 'pp',
  64: 'hay',
  65: 'haynode',
  66: 'use',
  67: 'error',
  68: 'failed',
  69: 'fork',
  70: 'forkwait',
  71: 'redir',
  72: 'fopen',
  73: 'shvar',
  74: 'ctx',
  75: 'invoke',
  76: 'runproc',
  77: 'boolstatus',
  78: 'test',
  79: 'bracket',
  80: 'push_registers',
  81: 'source_guard',
  82: 'is_main',
  83: 'cat',
  84: 'rm',
  85: 'sleep',
}

def builtin_str(val, dot=True):
  # type: (builtin_t, bool) -> str
  v = _builtin_str[val]
  if dot:
    return "builtin.%s" % v
  else:
    return v

