#ifndef ID_KIND_ASDL_H
#define ID_KIND_ASDL_H

#include <stdint.h>  // uint16_t

class BigStr;

namespace id_kind_asdl {

#define ASDL_NAMES struct
ASDL_NAMES Id {
  enum no_name {
  Word_Compound = 1,
  Arith_Semi = 2,
  Arith_Comma = 3,
  Arith_Plus = 4,
  Arith_Minus = 5,
  Arith_Star = 6,
  Arith_Slash = 7,
  Arith_Percent = 8,
  Arith_DPlus = 9,
  Arith_DMinus = 10,
  Arith_DStar = 11,
  Arith_LParen = 12,
  Arith_RParen = 13,
  Arith_LBracket = 14,
  Arith_RBracket = 15,
  Arith_RBrace = 16,
  Arith_QMark = 17,
  Arith_Colon = 18,
  Arith_LessEqual = 19,
  Arith_Less = 20,
  Arith_GreatEqual = 21,
  Arith_Great = 22,
  Arith_DEqual = 23,
  Arith_NEqual = 24,
  Arith_DAmp = 25,
  Arith_DPipe = 26,
  Arith_Bang = 27,
  Arith_DGreat = 28,
  Arith_DLess = 29,
  Arith_Amp = 30,
  Arith_Pipe = 31,
  Arith_Caret = 32,
  Arith_Tilde = 33,
  Arith_Equal = 34,
  Arith_PlusEqual = 35,
  Arith_MinusEqual = 36,
  Arith_StarEqual = 37,
  Arith_SlashEqual = 38,
  Arith_PercentEqual = 39,
  Arith_DGreatEqual = 40,
  Arith_DLessEqual = 41,
  Arith_AmpEqual = 42,
  Arith_CaretEqual = 43,
  Arith_PipeEqual = 44,
  Eof_Real = 45,
  Eof_RParen = 46,
  Eof_Backtick = 47,
  Undefined_Tok = 48,
  Unknown_Tok = 49,
  Unknown_Backslash = 50,
  Unknown_DEqual = 51,
  Unknown_DAmp = 52,
  Unknown_DPipe = 53,
  Unknown_DDot = 54,
  Eol_Tok = 55,
  Ignored_LineCont = 56,
  Ignored_Space = 57,
  Ignored_Comment = 58,
  Ignored_Newline = 59,
  WS_Space = 60,
  Lit_Chars = 61,
  Lit_CharsWithoutPrefix = 62,
  Lit_VarLike = 63,
  Lit_ArrayLhsOpen = 64,
  Lit_ArrayLhsClose = 65,
  Lit_Splice = 66,
  Lit_AtLBracket = 67,
  Lit_AtLBraceDot = 68,
  Lit_Other = 69,
  Lit_EscapedChar = 70,
  Lit_LBracket = 71,
  Lit_RBracket = 72,
  Lit_Star = 73,
  Lit_QMark = 74,
  Lit_LBrace = 75,
  Lit_RBrace = 76,
  Lit_Comma = 77,
  Lit_Equals = 78,
  Lit_Dollar = 79,
  Lit_DRightBracket = 80,
  Lit_Tilde = 81,
  Lit_Pound = 82,
  Lit_TPound = 83,
  Lit_TDot = 84,
  Lit_Slash = 85,
  Lit_Percent = 86,
  Lit_Colon = 87,
  Lit_Digits = 88,
  Lit_At = 89,
  Lit_ArithVarLike = 90,
  Lit_BadBackslash = 91,
  Lit_CompDummy = 92,
  Lit_Number = 93,
  Lit_RedirVarName = 94,
  Backtick_Right = 95,
  Backtick_Quoted = 96,
  Backtick_DoubleQuote = 97,
  Backtick_Other = 98,
  History_Op = 99,
  History_Num = 100,
  History_Search = 101,
  History_Other = 102,
  Op_Newline = 103,
  Op_Amp = 104,
  Op_Pipe = 105,
  Op_PipeAmp = 106,
  Op_DAmp = 107,
  Op_DPipe = 108,
  Op_Semi = 109,
  Op_DSemi = 110,
  Op_SemiAmp = 111,
  Op_DSemiAmp = 112,
  Op_LParen = 113,
  Op_RParen = 114,
  Op_DLeftParen = 115,
  Op_DRightParen = 116,
  Op_Less = 117,
  Op_Great = 118,
  Op_Bang = 119,
  Op_LBracket = 120,
  Op_RBracket = 121,
  Op_LBrace = 122,
  Op_RBrace = 123,
  Expr_Reserved = 124,
  Expr_Symbol = 125,
  Expr_Name = 126,
  Expr_DecInt = 127,
  Expr_BinInt = 128,
  Expr_OctInt = 129,
  Expr_HexInt = 130,
  Expr_Float = 131,
  Expr_Bang = 132,
  Expr_Dot = 133,
  Expr_DDotLessThan = 134,
  Expr_DDotEqual = 135,
  Expr_Colon = 136,
  Expr_RArrow = 137,
  Expr_RDArrow = 138,
  Expr_DSlash = 139,
  Expr_TEqual = 140,
  Expr_NotDEqual = 141,
  Expr_TildeDEqual = 142,
  Expr_At = 143,
  Expr_DoubleAt = 144,
  Expr_Ellipsis = 145,
  Expr_Dollar = 146,
  Expr_NotTilde = 147,
  Expr_DTilde = 148,
  Expr_NotDTilde = 149,
  Expr_DStarEqual = 150,
  Expr_DSlashEqual = 151,
  Expr_CastedDummy = 152,
  Expr_Null = 153,
  Expr_True = 154,
  Expr_False = 155,
  Expr_And = 156,
  Expr_Or = 157,
  Expr_Not = 158,
  Expr_For = 159,
  Expr_Is = 160,
  Expr_In = 161,
  Expr_If = 162,
  Expr_Else = 163,
  Expr_Capture = 164,
  Expr_As = 165,
  Expr_Func = 166,
  Expr_Proc = 167,
  Char_OneChar = 168,
  Char_Stop = 169,
  Char_Hex = 170,
  Char_YHex = 171,
  Char_Octal3 = 172,
  Char_Octal4 = 173,
  Char_Unicode4 = 174,
  Char_SurrogatePair = 175,
  Char_Unicode8 = 176,
  Char_UBraced = 177,
  Char_Pound = 178,
  Char_AsciiControl = 179,
  BashRegex_LParen = 180,
  BashRegex_AllowedInParens = 181,
  Eggex_Start = 182,
  Eggex_End = 183,
  Eggex_Dot = 184,
  Redir_Less = 185,
  Redir_Great = 186,
  Redir_DLess = 187,
  Redir_TLess = 188,
  Redir_DGreat = 189,
  Redir_GreatAnd = 190,
  Redir_LessAnd = 191,
  Redir_DLessDash = 192,
  Redir_LessGreat = 193,
  Redir_Clobber = 194,
  Redir_AndGreat = 195,
  Redir_AndDGreat = 196,
  Left_DoubleQuote = 197,
  Left_JDoubleQuote = 198,
  Left_SingleQuote = 199,
  Left_DollarSingleQuote = 200,
  Left_RSingleQuote = 201,
  Left_USingleQuote = 202,
  Left_BSingleQuote = 203,
  Left_TDoubleQuote = 204,
  Left_DollarTDoubleQuote = 205,
  Left_TSingleQuote = 206,
  Left_RTSingleQuote = 207,
  Left_UTSingleQuote = 208,
  Left_BTSingleQuote = 209,
  Left_Backtick = 210,
  Left_DollarParen = 211,
  Left_DollarBrace = 212,
  Left_DollarBraceZsh = 213,
  Left_DollarDParen = 214,
  Left_DollarBracket = 215,
  Left_DollarDoubleQuote = 216,
  Left_ProcSubIn = 217,
  Left_ProcSubOut = 218,
  Left_AtParen = 219,
  Left_CaretParen = 220,
  Left_CaretBracket = 221,
  Left_CaretBrace = 222,
  Left_CaretDoubleQuote = 223,
  Left_ColonPipe = 224,
  Left_PercentParen = 225,
  Right_DoubleQuote = 226,
  Right_SingleQuote = 227,
  Right_Backtick = 228,
  Right_DollarBrace = 229,
  Right_DollarDParen = 230,
  Right_DollarDoubleQuote = 231,
  Right_DollarSingleQuote = 232,
  Right_Subshell = 233,
  Right_ShFunction = 234,
  Right_CasePat = 235,
  Right_Initializer = 236,
  Right_ExtGlob = 237,
  Right_BashRegexGroup = 238,
  Right_BlockLiteral = 239,
  ExtGlob_Comma = 240,
  ExtGlob_At = 241,
  ExtGlob_Star = 242,
  ExtGlob_Plus = 243,
  ExtGlob_QMark = 244,
  ExtGlob_Bang = 245,
  VSub_DollarName = 246,
  VSub_Name = 247,
  VSub_Number = 248,
  VSub_Bang = 249,
  VSub_At = 250,
  VSub_Pound = 251,
  VSub_Dollar = 252,
  VSub_Star = 253,
  VSub_Hyphen = 254,
  VSub_QMark = 255,
  VSub_Dot = 256,
  VTest_ColonHyphen = 257,
  VTest_Hyphen = 258,
  VTest_ColonEquals = 259,
  VTest_Equals = 260,
  VTest_ColonQMark = 261,
  VTest_QMark = 262,
  VTest_ColonPlus = 263,
  VTest_Plus = 264,
  VOp0_Q = 265,
  VOp0_E = 266,
  VOp0_P = 267,
  VOp0_A = 268,
  VOp0_a = 269,
  VOp1_Percent = 270,
  VOp1_DPercent = 271,
  VOp1_Pound = 272,
  VOp1_DPound = 273,
  VOp1_Caret = 274,
  VOp1_DCaret = 275,
  VOp1_Comma = 276,
  VOp1_DComma = 277,
  VOpYsh_Pipe = 278,
  VOpYsh_Space = 279,
  VOp2_Slash = 280,
  VOp2_Colon = 281,
  VOp2_LBracket = 282,
  VOp2_RBracket = 283,
  VOp3_At = 284,
  VOp3_Star = 285,
  Node_PostDPlus = 286,
  Node_PostDMinus = 287,
  Node_UnaryPlus = 288,
  Node_UnaryMinus = 289,
  Node_NotIn = 290,
  Node_IsNot = 291,
  KW_DLeftBracket = 292,
  KW_Bang = 293,
  KW_For = 294,
  KW_While = 295,
  KW_Until = 296,
  KW_Do = 297,
  KW_Done = 298,
  KW_In = 299,
  KW_Case = 300,
  KW_Esac = 301,
  KW_If = 302,
  KW_Fi = 303,
  KW_Then = 304,
  KW_Else = 305,
  KW_Elif = 306,
  KW_Function = 307,
  KW_Time = 308,
  KW_Const = 309,
  KW_Var = 310,
  KW_SetVar = 311,
  KW_SetGlobal = 312,
  KW_Call = 313,
  KW_Proc = 314,
  KW_Typed = 315,
  KW_Func = 316,
  ControlFlow_Break = 317,
  ControlFlow_Continue = 318,
  ControlFlow_Return = 319,
  ControlFlow_Exit = 320,
  LookAhead_FuncParens = 321,
  Glob_LBracket = 322,
  Glob_RBracket = 323,
  Glob_Star = 324,
  Glob_QMark = 325,
  Glob_Bang = 326,
  Glob_Caret = 327,
  Glob_EscapedChar = 328,
  Glob_BadBackslash = 329,
  Glob_CleanLiterals = 330,
  Glob_OtherLiteral = 331,
  Format_EscapedPercent = 332,
  Format_Percent = 333,
  Format_Flag = 334,
  Format_Num = 335,
  Format_Dot = 336,
  Format_Type = 337,
  Format_Star = 338,
  Format_Time = 339,
  Format_Zero = 340,
  PS_Subst = 341,
  PS_Octal3 = 342,
  PS_LBrace = 343,
  PS_RBrace = 344,
  PS_Literals = 345,
  PS_BadBackslash = 346,
  Range_Int = 347,
  Range_Char = 348,
  Range_Dots = 349,
  Range_Other = 350,
  J8_LBracket = 351,
  J8_RBracket = 352,
  J8_LBrace = 353,
  J8_RBrace = 354,
  J8_Comma = 355,
  J8_Colon = 356,
  J8_Null = 357,
  J8_Bool = 358,
  J8_Int = 359,
  J8_Float = 360,
  J8_String = 361,
  J8_Identifier = 362,
  J8_Newline = 363,
  J8_Tab = 364,
  J8_LParen = 365,
  J8_RParen = 366,
  J8_Operator = 367,
  ShNumber_Dec = 368,
  ShNumber_Hex = 369,
  ShNumber_Oct = 370,
  ShNumber_BaseN = 371,
  BoolUnary_z = 372,
  BoolUnary_n = 373,
  BoolUnary_o = 374,
  BoolUnary_t = 375,
  BoolUnary_v = 376,
  BoolUnary_R = 377,
  BoolUnary_a = 378,
  BoolUnary_b = 379,
  BoolUnary_c = 380,
  BoolUnary_d = 381,
  BoolUnary_e = 382,
  BoolUnary_f = 383,
  BoolUnary_g = 384,
  BoolUnary_h = 385,
  BoolUnary_k = 386,
  BoolUnary_L = 387,
  BoolUnary_p = 388,
  BoolUnary_r = 389,
  BoolUnary_s = 390,
  BoolUnary_S = 391,
  BoolUnary_u = 392,
  BoolUnary_w = 393,
  BoolUnary_x = 394,
  BoolUnary_O = 395,
  BoolUnary_G = 396,
  BoolUnary_N = 397,
  BoolUnary_true = 398,
  BoolUnary_false = 399,
  BoolBinary_GlobEqual = 400,
  BoolBinary_GlobDEqual = 401,
  BoolBinary_GlobNEqual = 402,
  BoolBinary_EqualTilde = 403,
  BoolBinary_ef = 404,
  BoolBinary_nt = 405,
  BoolBinary_ot = 406,
  BoolBinary_eq = 407,
  BoolBinary_ne = 408,
  BoolBinary_gt = 409,
  BoolBinary_ge = 410,
  BoolBinary_lt = 411,
  BoolBinary_le = 412,
  BoolBinary_Equal = 413,
  BoolBinary_DEqual = 414,
  BoolBinary_NEqual = 415,
  ARRAY_SIZE = 416,
  };
};

BigStr* Id_str(int tag, bool dot = true);

typedef uint16_t Id_t;

enum class Kind {
  Word = 1,
  Arith = 2,
  Eof = 3,
  Undefined = 4,
  Unknown = 5,
  Eol = 6,
  Ignored = 7,
  WS = 8,
  Lit = 9,
  Backtick = 10,
  History = 11,
  Op = 12,
  Expr = 13,
  Char = 14,
  BashRegex = 15,
  Eggex = 16,
  Redir = 17,
  Left = 18,
  Right = 19,
  ExtGlob = 20,
  VSub = 21,
  VTest = 22,
  VOp0 = 23,
  VOp1 = 24,
  VOpYsh = 25,
  VOp2 = 26,
  VOp3 = 27,
  Node = 28,
  KW = 29,
  ControlFlow = 30,
  LookAhead = 31,
  Glob = 32,
  Format = 33,
  PS = 34,
  Range = 35,
  J8 = 36,
  ShNumber = 37,
  BoolUnary = 38,
  BoolBinary = 39,
};
typedef Kind Kind_t;

BigStr* Kind_str(Kind tag, bool dot = true);


}  // namespace id_kind_asdl

#endif  // ID_KIND_ASDL_H
